/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.inject.TypeLiteral;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Status;

public class WsBinaryMessage
implements Mutant {
    private ByteBuffer buffer;

    public WsBinaryMessage(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean booleanValue() {
        throw this.typeError(Boolean.TYPE);
    }

    @Override
    public byte byteValue() {
        throw this.typeError(Byte.TYPE);
    }

    @Override
    public short shortValue() {
        throw this.typeError(Short.TYPE);
    }

    @Override
    public int intValue() {
        throw this.typeError(Integer.TYPE);
    }

    @Override
    public long longValue() {
        throw this.typeError(Long.TYPE);
    }

    @Override
    public String value() {
        throw this.typeError(String.class);
    }

    @Override
    public float floatValue() {
        throw this.typeError(Float.TYPE);
    }

    @Override
    public double doubleValue() {
        throw this.typeError(Double.TYPE);
    }

    @Override
    public <T extends Enum<T>> T toEnum(Class<T> type) {
        throw this.typeError(type);
    }

    @Override
    public <T> List<T> toList(Class<T> type) {
        throw this.typeError(type);
    }

    @Override
    public <T> Set<T> toSet(Class<T> type) {
        throw this.typeError(type);
    }

    @Override
    public <T extends Comparable<T>> SortedSet<T> toSortedSet(Class<T> type) {
        throw this.typeError(type);
    }

    @Override
    public <T> Optional<T> toOptional(Class<T> type) {
        throw this.typeError(type);
    }

    @Override
    public <T> T to(TypeLiteral<T> type) {
        return this.to(type, MediaType.octetstream);
    }

    @Override
    public <T> T to(TypeLiteral<T> type, MediaType mtype) {
        Class<T> rawType = type.getRawType();
        if (rawType == byte[].class) {
            if (this.buffer.hasArray()) {
                return (T)this.buffer.array();
            }
            byte[] bytes = new byte[this.buffer.remaining()];
            this.buffer.get(bytes);
            return (T)bytes;
        }
        if (rawType == ByteBuffer.class) {
            return (T)this.buffer;
        }
        if (rawType == InputStream.class) {
            return (T)new ByteArrayInputStream(this.buffer.array());
        }
        if (rawType == Reader.class) {
            return (T)new InputStreamReader((InputStream)new ByteArrayInputStream(this.buffer.array()), Charsets.UTF_8);
        }
        throw this.typeError(rawType);
    }

    @Override
    public Map<String, Mutant> toMap() {
        return ImmutableMap.of("message", this);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    private Err typeError(Class<?> type) {
        return new Err(Status.BAD_REQUEST, "Can't convert to " + ByteBuffer.class.getName() + " to " + type);
    }
}

