/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Renderer;
import org.jooby.Request;
import org.jooby.WebSocket;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.internal.ConnectionResetByPeer;
import org.jooby.internal.MutantImpl;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.WebSocketRendererContext;
import org.jooby.internal.WsBinaryMessage;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.spi.NativeWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
implements WebSocket {
    private static final WebSocket.OnMessage NOOP = arg -> {};
    private static final WebSocket.OnClose CLOSE_NOOP = arg -> {};
    private static final Predicate<Throwable> RESET_BY_PEER = ConnectionResetByPeer::test;
    private static final Predicate<Throwable> SILENT = RESET_BY_PEER.or(ClosedChannelException.class::isInstance).or(EOFException.class::isInstance);
    private final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private static final ConcurrentMap<String, List<WebSocket>> sessions = new ConcurrentHashMap<String, List<WebSocket>>();
    private Locale locale;
    private String path;
    private String pattern;
    private Map<Object, String> vars;
    private MediaType consumes;
    private MediaType produces;
    private WebSocket.OnOpen handler;
    private WebSocket.OnMessage<Mutant> messageCallback = NOOP;
    private WebSocket.OnClose closeCallback = CLOSE_NOOP;
    private WebSocket.OnError exceptionCallback = cause -> this.log.error("execution of WS" + this.path() + " resulted in exception", cause);
    private NativeWebSocket ws;
    private Injector injector;
    private boolean suspended;
    private List<Renderer> renderers;
    private volatile boolean open;
    private ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public WebSocketImpl(WebSocket.OnOpen handler, String path, String pattern, Map<Object, String> vars, MediaType consumes, MediaType produces) {
        this.handler = handler;
        this.path = path;
        this.pattern = pattern;
        this.vars = vars;
        this.consumes = consumes;
        this.produces = produces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(WebSocket.CloseStatus status) {
        WebSocketImpl.removeSession(this);
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            this.open = false;
            if (this.ws != null) {
                this.ws.close(status.code(), status.reason());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        WebSocketImpl.addSession(this);
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (this.suspended) {
                this.ws.resume();
                this.suspended = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        WebSocketImpl.removeSession(this);
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (!this.suspended) {
                this.ws.pause();
                this.suspended = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() throws Exception {
        WebSocketImpl.removeSession(this);
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            this.open = false;
            this.ws.terminate();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open && this.ws.isOpen();
    }

    @Override
    public void broadcast(Object data, WebSocket.SuccessCallback success, WebSocket.OnError err) throws Exception {
        for (WebSocket ws : sessions.getOrDefault(this.pattern, Collections.emptyList())) {
            try {
                ws.send(data, success, err);
            }
            catch (Exception ex) {
                err.onError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Object data, WebSocket.SuccessCallback success, WebSocket.OnError err) throws Exception {
        Objects.requireNonNull(data, "Message required.");
        Objects.requireNonNull(success, "Success callback required.");
        Objects.requireNonNull(err, "Error callback required.");
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (!this.isOpen()) {
                throw new Err(WebSocket.NORMAL, "WebSocket is closed.");
            }
            new WebSocketRendererContext(this.renderers, this.ws, this.produces, StandardCharsets.UTF_8, this.locale, success, err).render(data);
        }
    }

    @Override
    public void onMessage(WebSocket.OnMessage<Mutant> callback) throws Exception {
        this.messageCallback = Objects.requireNonNull(callback, "Message callback required.");
    }

    public void connect(Injector injector, Request req, NativeWebSocket ws) {
        this.open = true;
        this.injector = Objects.requireNonNull(injector, "Injector required.");
        this.ws = Objects.requireNonNull(ws, "WebSocket is required.");
        this.locale = req.locale();
        this.renderers = ImmutableList.copyOf((Collection)injector.getInstance(Renderer.KEY));
        ws.onBinaryMessage(buffer -> Try.run(this.sync(() -> this.messageCallback.onMessage(new WsBinaryMessage((ByteBuffer)buffer)))).onFailure(this::handleErr));
        ws.onTextMessage(message -> Try.run(this.sync(() -> this.messageCallback.onMessage(new MutantImpl(injector.getInstance(ParserExecutor.class), this.consumes, new StrParamReferenceImpl("body", "message", (List<String>)ImmutableList.of(message)))))).onFailure(this::handleErr));
        ws.onCloseMessage((code, reason) -> {
            WebSocketImpl.removeSession(this);
            Try.run(this.sync(() -> {
                this.open = false;
                if (this.closeCallback != null) {
                    this.closeCallback.onClose(reason.map(r -> WebSocket.CloseStatus.of(code, r)).orElse(WebSocket.CloseStatus.of(code)));
                }
                this.closeCallback = null;
            })).onFailure(this::handleErr);
        });
        ws.onErrorMessage(this::handleErr);
        try {
            WebSocketImpl.addSession(this);
            this.handler.onOpen(req, this);
        }
        catch (Throwable ex) {
            this.handleErr(ex);
        }
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public Map<Object, String> vars() {
        return this.vars;
    }

    @Override
    public MediaType consumes() {
        return this.consumes;
    }

    @Override
    public MediaType produces() {
        return this.produces;
    }

    @Override
    public <T> T require(Key<T> key) {
        return this.injector.getInstance(key);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("WS ").append(this.path()).append("\n");
        buffer.append("  pattern: ").append(this.pattern()).append("\n");
        buffer.append("  vars: ").append(this.vars()).append("\n");
        buffer.append("  consumes: ").append(this.consumes()).append("\n");
        buffer.append("  produces: ").append(this.produces()).append("\n");
        return buffer.toString();
    }

    @Override
    public void onError(WebSocket.OnError callback) {
        this.exceptionCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    @Override
    public void onClose(WebSocket.OnClose callback) throws Exception {
        this.closeCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    @Override
    public <T> T get(String name) {
        return this.ifGet(name).orElseThrow(() -> new NullPointerException(name));
    }

    @Override
    public <T> Optional<T> ifGet(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    @Override
    @Nullable
    public WebSocket set(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public <T> Optional<T> unset(String name) {
        return Optional.ofNullable(this.attributes.remove(name));
    }

    @Override
    public WebSocket unset() {
        this.attributes.clear();
        return this;
    }

    @Override
    public Map<String, Object> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    private void handleErr(Throwable cause) {
        Try.run(() -> {
            if (SILENT.test(cause)) {
                this.log.debug("execution of WS" + this.path() + " resulted in exception", cause);
            } else {
                this.exceptionCallback.onError(cause);
            }
        }).onComplete(() -> this.cleanup(cause)).throwException();
    }

    private void cleanup(Throwable cause) {
        this.open = false;
        NativeWebSocket lws = this.ws;
        this.ws = null;
        this.injector = null;
        this.handler = null;
        this.closeCallback = null;
        this.exceptionCallback = null;
        this.messageCallback = null;
        if (lws != null && lws.isOpen()) {
            Err err;
            WebSocket.CloseStatus closeStatus = WebSocket.SERVER_ERROR;
            if (cause instanceof IllegalArgumentException) {
                closeStatus = WebSocket.BAD_DATA;
            } else if (cause instanceof NoSuchElementException) {
                closeStatus = WebSocket.BAD_DATA;
            } else if (cause instanceof Err && (err = (Err)cause).statusCode() == 400) {
                closeStatus = WebSocket.BAD_DATA;
            }
            lws.close(closeStatus.code(), closeStatus.reason());
        }
    }

    private Throwing.Runnable sync(Throwing.Runnable task) {
        return () -> {
            WebSocketImpl webSocketImpl = this;
            synchronized (webSocketImpl) {
                task.run();
            }
        };
    }

    private static void addSession(WebSocketImpl ws) {
        sessions.computeIfAbsent(ws.pattern, k -> new CopyOnWriteArrayList()).add(ws);
    }

    private static void removeSession(WebSocketImpl ws) {
        Optional.ofNullable(sessions.get(ws.pattern)).ifPresent(list -> list.remove(ws));
    }
}

