/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Status;
import org.jooby.internal.AbstractRendererContext;
import org.jooby.internal.ByteRange;
import org.jooby.spi.NativeResponse;

public class HttpRendererContext
extends AbstractRendererContext {
    private Consumer<Long> length;
    private Consumer<MediaType> type;
    private NativeResponse rsp;
    private Optional<String> byteRange;

    public HttpRendererContext(List<Renderer> renderers, NativeResponse rsp, Consumer<Long> len, Consumer<MediaType> type, Map<String, Object> locals, List<MediaType> produces, Charset charset, Locale locale, Optional<String> byteRange) {
        super(renderers, produces, charset, locale, locals);
        this.byteRange = byteRange;
        this.rsp = rsp;
        this.length = len;
        this.type = type;
    }

    @Override
    public Renderer.Context length(long length) {
        this.length.accept(length);
        return this;
    }

    @Override
    public Renderer.Context type(MediaType type) {
        this.type.accept(type);
        return this;
    }

    @Override
    protected void _send(ByteBuffer buffer) throws Exception {
        this.rsp.send(buffer);
    }

    @Override
    protected void _send(byte[] bytes) throws Exception {
        this.rsp.send(bytes);
    }

    @Override
    protected void _send(FileChannel file) throws Exception {
        long[] byteRange = this.byteRange();
        if (byteRange == null) {
            this.rsp.send(file);
        } else {
            this.rsp.send(file, byteRange[0], byteRange[1]);
        }
    }

    @Override
    protected void _send(InputStream stream) throws Exception {
        long[] byteRange = this.byteRange();
        if (byteRange == null) {
            this.rsp.send(stream);
        } else {
            stream.skip(byteRange[0]);
            this.rsp.send(ByteStreams.limit(stream, byteRange[1]));
        }
    }

    private long[] byteRange() {
        long len = this.rsp.header("Content-Length").map(Long::parseLong).orElse(-1L);
        if (len > 0L && this.byteRange.isPresent()) {
            String raw = this.byteRange.get();
            long[] range = ByteRange.parse(raw);
            long start = range[0];
            long end = range[1];
            if (start == -1L) {
                start = len - end;
                end = len - 1L;
            }
            if (end == -1L || end > len - 1L) {
                end = len - 1L;
            }
            if (start > end) {
                throw new Err(Status.REQUESTED_RANGE_NOT_SATISFIABLE, raw);
            }
            long limit = end - start + 1L;
            this.rsp.header("Accept-Ranges", "bytes");
            this.rsp.header("Content-Range", "bytes " + start + "-" + end + "/" + len);
            this.rsp.header("Content-Length", Long.toString(limit));
            this.rsp.statusCode(Status.PARTIAL_CONTENT.value());
            return new long[]{start, limit};
        }
        return null;
    }
}

