/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.jooby.Deferred;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Renderer;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.internal.SseRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sse
implements AutoCloseable {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "sse-heartbeat");
        thread.setDaemon(true);
        return thread;
    });
    static final byte[] HEART_BEAT = ":\n".getBytes(StandardCharsets.UTF_8);
    protected final Logger log = LoggerFactory.getLogger(Sse.class);
    private Injector injector;
    private List<Renderer> renderers;
    private final String id;
    private List<MediaType> produces;
    private Map<String, Object> locals;
    private AtomicReference<Throwing.Runnable> onclose = new AtomicReference<Object>(null);
    private Mutant lastEventId;
    private boolean closed;
    private Locale locale;

    public Sse() {
        this.id = UUID.randomUUID().toString();
    }

    protected void handshake(Request req, Runnable handler) throws Exception {
        this.injector = req.require(Injector.class);
        this.renderers = ImmutableList.copyOf((Collection)this.injector.getInstance(Renderer.KEY));
        this.produces = req.route().produces();
        this.locals = req.attributes();
        this.lastEventId = req.header("Last-Event-ID");
        this.locale = req.locale();
        this.handshake(handler);
    }

    protected abstract void handshake(Runnable var1) throws Exception;

    @Nonnull
    public String id() {
        return this.id;
    }

    @Nonnull
    public Optional<String> lastEventId() {
        return this.lastEventId(String.class);
    }

    @Nonnull
    public <T> Optional<T> lastEventId(Class<T> type) {
        return this.lastEventId.toOptional(type);
    }

    @Nonnull
    public Sse onClose(Throwing.Runnable task) {
        this.onclose.set(task);
        return this;
    }

    @Nonnull
    public CompletableFuture<Optional<Object>> send(Object data, String type) {
        return this.send(data, MediaType.valueOf(type));
    }

    @Nonnull
    public CompletableFuture<Optional<Object>> send(Object data, MediaType type) {
        return this.event(data).type(type).send();
    }

    @Nonnull
    public CompletableFuture<Optional<Object>> send(Object data) {
        return this.event(data).send();
    }

    @Nonnull
    public Event event(Object data) {
        return new Event(this, data);
    }

    @Nonnull
    public <T> T require(Class<T> type) {
        return this.require(Key.get(type));
    }

    @Nonnull
    public <T> T require(String name, Class<T> type) {
        return this.require(Key.get(type, (Annotation)Names.named(name)));
    }

    @Nonnull
    public <T> T require(TypeLiteral<T> type) {
        return this.require(Key.get(type));
    }

    @Nonnull
    public <T> T require(Key<T> key) {
        return this.injector.getInstance(key);
    }

    @Nonnull
    public Sse keepAlive(int time, TimeUnit unit) {
        return this.keepAlive(unit.toMillis(time));
    }

    @Nonnull
    public Sse keepAlive(long millis) {
        scheduler.schedule(new KeepAlive(this, millis), millis, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public final void close() throws Exception {
        this.closeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAll() {
        Sse sse = this;
        synchronized (sse) {
            if (!this.closed) {
                this.closed = true;
                this.fireCloseEvent();
                this.closeInternal();
            }
        }
    }

    protected abstract void closeInternal();

    protected abstract CompletableFuture<Optional<Object>> send(Optional<Object> var1, byte[] var2);

    protected void ifClose(Throwable cause) {
        if (this.shouldClose(cause)) {
            this.closeAll();
        }
    }

    protected void fireCloseEvent() {
        Throwing.Runnable task = this.onclose.getAndSet(null);
        if (task != null) {
            Try.run(task).onFailure(ex -> this.log.error("close callback resulted in error", ex));
        }
    }

    protected boolean shouldClose(Throwable ex) {
        if (ex instanceof IOException) {
            boolean brokenPipe = Optional.ofNullable(ex.getMessage()).map(m4 -> m4.toLowerCase().contains("broken pipe")).orElse(false);
            return brokenPipe || ex instanceof ClosedChannelException;
        }
        return false;
    }

    private CompletableFuture<Optional<Object>> send(Event event) {
        List<MediaType> produces = event.type().map(ImmutableList::of).orElse(this.produces);
        SseRenderer ctx = new SseRenderer(this.renderers, produces, StandardCharsets.UTF_8, this.locale, this.locals);
        return Try.apply(() -> {
            byte[] bytes = ctx.format(event);
            return this.send(event.id(), bytes);
        }).recover(x -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally((Throwable)x);
            return future;
        }).get();
    }

    static class KeepAlive
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(Sse.class);
        private Sse sse;
        private long retry;

        public KeepAlive(Sse sse, long retry) {
            this.sse = sse;
            this.retry = retry;
        }

        @Override
        public void run() {
            String sseId = this.sse.id();
            this.log.debug("running heart beat for {}", (Object)sseId);
            Try.run(() -> this.sse.send(Optional.of(sseId), HEART_BEAT).whenComplete((id, x) -> {
                if (x != null) {
                    this.log.debug("connection lost for {}", (Object)sseId, x);
                    this.sse.fireCloseEvent();
                    Try.run(this.sse::close);
                } else {
                    this.log.debug("reschedule heart beat for {}", id);
                    this.sse.keepAlive(this.retry);
                }
            }));
        }
    }

    public static interface Handler1
    extends Handler {
        @Override
        default public void handle(Request req, Sse sse) throws Exception {
            this.handle(sse);
        }

        public void handle(Sse var1) throws Exception;
    }

    public static interface Handler
    extends Route.Filter {
        @Override
        default public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
            Sse sse = req.require(Sse.class);
            String path = req.path();
            rsp.send(new Deferred(deferred -> {
                try {
                    sse.handshake(req, () -> Try.run(() -> this.handle(req, sse)).onSuccess(() -> deferred.resolve(null)).onFailure(ex -> {
                        deferred.reject((Throwable)ex);
                        Logger log = LoggerFactory.getLogger(Sse.class);
                        log.error("execution of {} resulted in error", (Object)path, ex);
                    }));
                }
                catch (Exception ex) {
                    deferred.reject(ex);
                }
            }));
        }

        public void handle(Request var1, Sse var2) throws Exception;
    }

    public static class Event {
        private Object id;
        private String name;
        private Object data;
        private Long retry;
        private MediaType type;
        private String comment;
        private Sse sse;

        private Event(Sse sse, Object data) {
            this.sse = sse;
            this.data = data;
        }

        public Optional<Object> data() {
            return Optional.ofNullable(this.data);
        }

        public Optional<MediaType> type() {
            return Optional.ofNullable(this.type);
        }

        public Event type(MediaType type) {
            this.type = Objects.requireNonNull(type, "Type is required.");
            return this;
        }

        public Event type(String type) {
            return this.type(MediaType.valueOf(type));
        }

        public Optional<Object> id() {
            return Optional.ofNullable(this.id);
        }

        public Event id(Object id) {
            this.id = Objects.requireNonNull(id, "Id is required.");
            return this;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Event name(String name) {
            this.name = Objects.requireNonNull(name, "Name is required.");
            return this;
        }

        public Event retry(int retry, TimeUnit unit) {
            this.retry = unit.toMillis(retry);
            return this;
        }

        public Event retry(long retry) {
            this.retry = retry;
            return this;
        }

        public Optional<String> comment() {
            return Optional.ofNullable(this.comment);
        }

        public Event comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "Comment is required.");
            return this;
        }

        public Optional<Long> retry() {
            return Optional.ofNullable(this.retry);
        }

        public CompletableFuture<Optional<Object>> send() {
            CompletableFuture future = this.sse.send(this);
            this.id = null;
            this.name = null;
            this.data = null;
            this.type = null;
            this.sse = null;
            return future;
        }
    }
}

