/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Result;
import org.jooby.funzy.Throwing;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.RouteImpl;
import org.jooby.internal.RouteMatcher;
import org.jooby.internal.RoutePattern;
import org.jooby.internal.RouteSourceImpl;
import org.jooby.internal.SourceProvider;

public interface Route {
    public static final Key<Set<Definition>> KEY = Key.get(new TypeLiteral<Set<Definition>>(){});
    public static final char OUT_OF_PATH = '\u200b';
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String PATCH = "PATCH";
    public static final String HEAD = "HEAD";
    public static final String CONNECT = "CONNECT";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";
    public static final List<String> METHODS = ((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "CONNECT", "OPTIONS", "TRACE"})).build();

    @Nonnull
    public String path();

    @Nonnull
    public String method();

    @Nonnull
    public String pattern();

    @Nonnull
    public String name();

    @Nonnull
    public Map<Object, String> vars();

    @Nonnull
    public List<MediaType> consumes();

    @Nonnull
    public List<MediaType> produces();

    default public boolean apply(String prefix) {
        return this.name().startsWith(prefix);
    }

    @Nonnull
    public Map<String, Object> attributes();

    @Nonnull
    default public <T> T attr(String name) {
        return (T)this.attributes().get(name);
    }

    @Nonnull
    public String renderer();

    public boolean glob();

    @Nonnull
    public String reverse(Map<String, Object> var1);

    @Nonnull
    public String reverse(Object ... var1);

    @Nonnull
    public static String normalize(String path) {
        return RoutePattern.normalize(path);
    }

    @Nonnull
    public static String unerrpath(String path) {
        if (path.charAt(0) == '\u200b') {
            return path.substring(1);
        }
        return path;
    }

    @Nonnull
    public static String errpath(String path) {
        return '\u200b' + path;
    }

    @Nonnull
    public Source source();

    @Nonnull
    default public String print(int indent) {
        StringBuilder buff = new StringBuilder();
        String[] header = new String[]{"Method", "Path", "Source", "Name", "Pattern", "Consumes", "Produces"};
        String[] values = new String[]{this.method(), this.path(), this.source().toString(), this.name(), this.pattern(), this.consumes().toString(), this.produces().toString()};
        BiConsumer<Function, Character> format = (v, s2) -> {
            buff.append(Strings.padEnd("", indent, ' ')).append("|").append(s2);
            for (int i = 0; i < header.length; ++i) {
                buff.append(Strings.padEnd((String)v.apply(i), Math.max(header[i].length(), values[i].length()), s2.charValue())).append(s2).append("|").append(s2);
            }
            buff.setLength(buff.length() - 1);
        };
        format.accept(i -> header[i], Character.valueOf(' '));
        buff.append("\n");
        format.accept(i -> "-", Character.valueOf('-'));
        buff.append("\n");
        format.accept(i -> values[i], Character.valueOf(' '));
        return buff.toString();
    }

    @Nonnull
    default public String print() {
        return this.print(0);
    }

    public static interface Chain {
        public void next(@Nullable String var1, Request var2, Response var3) throws Throwable;

        default public void next(Request req, Response rsp) throws Throwable {
            this.next(null, req, rsp);
        }

        public List<Route> routes();
    }

    public static interface Complete
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            rsp.complete(this);
            chain.next(req, rsp);
        }

        public void handle(Request var1, Response var2, Optional<Throwable> var3);
    }

    public static interface After
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            rsp.after(this);
            chain.next(req, rsp);
        }

        public Result handle(Request var1, Response var2, Result var3) throws Exception;
    }

    public static interface Before
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            this.handle(req, rsp);
            chain.next(req, rsp);
        }

        public void handle(Request var1, Response var2) throws Throwable;
    }

    public static interface ZeroArgHandler
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            Object result = this.handle();
            rsp.send(result);
            chain.next(req, rsp);
        }

        public Object handle() throws Throwable;
    }

    public static interface OneArgHandler
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            Object result = this.handle(req);
            rsp.send(result);
            chain.next(req, rsp);
        }

        public Object handle(Request var1) throws Throwable;
    }

    public static interface MethodHandler
    extends Handler {
        @Nonnull
        public Method method();

        @Nonnull
        public Class<?> implementingClass();
    }

    public static interface Handler
    extends Filter {
        @Override
        default public void handle(Request req, Response rsp, Chain chain) throws Throwable {
            this.handle(req, rsp);
            chain.next(req, rsp);
        }

        public void handle(Request var1, Response var2) throws Throwable;
    }

    public static class AssetDefinition
    extends Definition {
        private Boolean etag;
        private String cdn;
        private Object maxAge;
        private Boolean lastModifiedSince;
        private Integer statusCode;

        public AssetDefinition(String method, String pattern, Filter handler, boolean caseSensitiveRouting) {
            super(method, pattern, handler, caseSensitiveRouting);
            this.filter().setRoute(this);
        }

        @Override
        @Nonnull
        public AssetHandler filter() {
            return (AssetHandler)super.filter();
        }

        public AssetDefinition onMissing(int statusCode) {
            if (this.statusCode == null) {
                this.filter().onMissing(statusCode);
                this.statusCode = statusCode;
            }
            return this;
        }

        public AssetDefinition etag(boolean etag) {
            if (this.etag == null) {
                this.filter().etag(etag);
                this.etag = etag;
            }
            return this;
        }

        public AssetDefinition lastModified(boolean enabled) {
            if (this.lastModifiedSince == null) {
                this.filter().lastModified(enabled);
                this.lastModifiedSince = enabled;
            }
            return this;
        }

        public AssetDefinition cdn(String cdn) {
            if (this.cdn == null) {
                this.filter().cdn(cdn);
                this.cdn = cdn;
            }
            return this;
        }

        public AssetDefinition maxAge(Duration maxAge) {
            if (this.maxAge == null) {
                this.filter().maxAge(maxAge);
                this.maxAge = maxAge;
            }
            return this;
        }

        public AssetDefinition maxAge(long maxAge) {
            if (this.maxAge == null) {
                this.filter().maxAge(maxAge);
                this.maxAge = maxAge;
            }
            return this;
        }

        public AssetDefinition maxAge(String maxAge) {
            if (this.maxAge == null) {
                this.filter().maxAge(maxAge);
                this.maxAge = maxAge;
            }
            return this;
        }
    }

    public static interface Filter {
        public void handle(Request var1, Response var2, Chain var3) throws Throwable;
    }

    public static class Forwarding
    implements Route {
        private final Route route;

        public Forwarding(Route route) {
            this.route = route;
        }

        @Override
        public String renderer() {
            return this.route.renderer();
        }

        @Override
        public String path() {
            return this.route.path();
        }

        @Override
        public String method() {
            return this.route.method();
        }

        @Override
        public String pattern() {
            return this.route.pattern();
        }

        @Override
        public String name() {
            return this.route.name();
        }

        @Override
        public Map<Object, String> vars() {
            return this.route.vars();
        }

        @Override
        public List<MediaType> consumes() {
            return this.route.consumes();
        }

        @Override
        public List<MediaType> produces() {
            return this.route.produces();
        }

        @Override
        public Map<String, Object> attributes() {
            return this.route.attributes();
        }

        @Override
        public <T> T attr(String name) {
            return this.route.attr(name);
        }

        @Override
        public boolean glob() {
            return this.route.glob();
        }

        @Override
        public String reverse(Map<String, Object> vars) {
            return this.route.reverse(vars);
        }

        @Override
        public String reverse(Object ... values) {
            return this.route.reverse(values);
        }

        @Override
        public Source source() {
            return this.route.source();
        }

        @Override
        public String print() {
            return this.route.print();
        }

        @Override
        public String print(int indent) {
            return this.route.print(indent);
        }

        public String toString() {
            return this.route.toString();
        }

        public static Route unwrap(Route route) {
            Route root = route;
            while (root instanceof Forwarding) {
                root = ((Forwarding)root).route;
            }
            return root;
        }
    }

    public static class Definition
    implements Props<Definition> {
        private String name = "/anonymous";
        private RoutePattern cpattern;
        private Filter filter;
        private List<MediaType> consumes = MediaType.ALL;
        private List<MediaType> produces = MediaType.ALL;
        private String method;
        private String pattern;
        private List<RoutePattern> excludes = Collections.emptyList();
        private Map<String, Object> attributes = ImmutableMap.of();
        private Mapper<?> mapper;
        private int line;
        private String declaringClass;
        String prefix;
        private String renderer;

        public Definition(String verb, String pattern, Handler handler) {
            this(verb, pattern, (Filter)handler);
        }

        public Definition(String verb, String pattern, Handler handler, boolean caseSensitiveRouting) {
            this(verb, pattern, (Filter)handler, caseSensitiveRouting);
        }

        public Definition(String verb, String pattern, OneArgHandler handler) {
            this(verb, pattern, (Filter)handler);
        }

        public Definition(String verb, String pattern, ZeroArgHandler handler) {
            this(verb, pattern, (Filter)handler);
        }

        public Definition(String method, String pattern, Filter filter) {
            this(method, pattern, filter, true);
        }

        public Definition(String method, String pattern, Filter filter, boolean caseSensitiveRouting) {
            Objects.requireNonNull(pattern, "A route path is required.");
            Objects.requireNonNull(filter, "A filter is required.");
            this.method = method.toUpperCase();
            this.cpattern = new RoutePattern(method, pattern, !caseSensitiveRouting);
            this.pattern = this.cpattern.pattern();
            this.filter = filter;
            SourceProvider.INSTANCE.get().ifPresent(source -> {
                this.line = source.getLineNumber();
                this.declaringClass = source.getClassName();
            });
        }

        @Nonnull
        public String pattern() {
            return this.pattern;
        }

        @Override
        @Nullable
        public String renderer() {
            return this.renderer;
        }

        @Override
        public Definition renderer(String name) {
            this.renderer = name;
            return this;
        }

        @Nonnull
        public List<String> vars() {
            return this.cpattern.vars();
        }

        @Nonnull
        public boolean glob() {
            return this.cpattern.glob();
        }

        @Nonnull
        public Source source() {
            return new RouteSourceImpl(this.declaringClass, this.line);
        }

        @Nonnull
        public String reverse(Map<String, Object> vars) {
            return this.cpattern.reverse(vars);
        }

        @Nonnull
        public String reverse(Object ... values) {
            return this.cpattern.reverse(values);
        }

        @Override
        @Nonnull
        public Definition attr(String name, Object value) {
            Objects.requireNonNull(name, "Attribute name is required.");
            Objects.requireNonNull(value, "Attribute value is required.");
            if (this.valid(value)) {
                this.attributes = ImmutableMap.builder().putAll(this.attributes).put(name, value).build();
            }
            return this;
        }

        private boolean valid(Object value) {
            if (Primitives.isWrapperType(Primitives.wrap(value.getClass()))) {
                return true;
            }
            if (value instanceof String || value instanceof Enum || value instanceof Class) {
                return true;
            }
            if (value.getClass().isArray() && Array.getLength(value) > 0) {
                return this.valid(Array.get(value, 0));
            }
            if (value instanceof Map && ((Map)value).size() > 0) {
                Map.Entry e = ((Map)value).entrySet().iterator().next();
                return this.valid(e.getKey()) && this.valid(e.getValue());
            }
            return false;
        }

        @Nonnull
        public <T> T attr(String name) {
            return (T)this.attributes.get(name);
        }

        @Nonnull
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Nonnull
        public Optional<Route> matches(String method, String path, MediaType contentType, List<MediaType> accept) {
            List<MediaType> result;
            String fpath = method + path;
            if (this.excludes.size() > 0 && this.excludes(fpath)) {
                return Optional.empty();
            }
            RouteMatcher matcher = this.cpattern.matcher(fpath);
            if (matcher.matches() && (result = MediaType.matcher(accept).filter(this.produces)).size() > 0 && this.canConsume(contentType)) {
                List<MediaType> produces = result.size() == 1 && result.get(0).name().equals("*/*") ? accept : this.produces;
                return Optional.of(this.asRoute(method, matcher, produces, new RouteSourceImpl(this.declaringClass, this.line)));
            }
            return Optional.empty();
        }

        @Nonnull
        public String method() {
            return this.method;
        }

        @Nonnull
        public Filter filter() {
            return this.filter;
        }

        @Nonnull
        public String name() {
            return this.name;
        }

        @Override
        @Nonnull
        public Definition name(String name) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "A route's name is required.");
            this.name = Route.normalize(this.prefix != null ? this.prefix + "/" + name : name);
            return this;
        }

        public boolean canConsume(MediaType type) {
            return MediaType.matcher(Arrays.asList(type)).matches(this.consumes);
        }

        public boolean canConsume(String type) {
            return MediaType.matcher(MediaType.valueOf(type)).matches(this.consumes);
        }

        public boolean canProduce(List<MediaType> types) {
            return MediaType.matcher(types).matches(this.produces);
        }

        public boolean canProduce(MediaType ... types) {
            return this.canProduce(Arrays.asList(types));
        }

        public boolean canProduce(String ... types) {
            return this.canProduce(MediaType.valueOf(types));
        }

        @Override
        public Definition consumes(List<MediaType> types) {
            Preconditions.checkArgument(types != null && types.size() > 0, "Consumes types are required");
            if (types.size() > 1) {
                this.consumes = Lists.newLinkedList(types);
                Collections.sort(this.consumes);
            } else {
                this.consumes = ImmutableList.of(types.get(0));
            }
            return this;
        }

        @Override
        public Definition produces(List<MediaType> types) {
            Preconditions.checkArgument(types != null && types.size() > 0, "Produces types are required");
            if (types.size() > 1) {
                this.produces = Lists.newLinkedList(types);
                Collections.sort(this.produces);
            } else {
                this.produces = ImmutableList.of(types.get(0));
            }
            return this;
        }

        @Override
        public Definition excludes(List<String> excludes) {
            this.excludes = excludes.stream().map((? super T it) -> new RoutePattern(this.method, (String)it)).collect(Collectors.toList());
            return this;
        }

        @Nonnull
        public List<String> excludes() {
            return this.excludes.stream().map((? super T r) -> r.pattern()).collect(Collectors.toList());
        }

        private boolean excludes(String path) {
            for (RoutePattern pattern : this.excludes) {
                if (!pattern.matcher(path).matches()) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public List<MediaType> consumes() {
            return Collections.unmodifiableList(this.consumes);
        }

        @Nonnull
        public List<MediaType> produces() {
            return Collections.unmodifiableList(this.produces);
        }

        @Override
        @Nonnull
        public Definition map(Mapper<?> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper is required.");
            return this;
        }

        @Nonnull
        public Definition line(int line) {
            this.line = line;
            return this;
        }

        @Nonnull
        public Definition declaringClass(String declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.method()).append(" ").append(this.pattern()).append("\n");
            buffer.append("  name: ").append(this.name()).append("\n");
            buffer.append("  excludes: ").append(this.excludes).append("\n");
            buffer.append("  consumes: ").append(this.consumes()).append("\n");
            buffer.append("  produces: ").append(this.produces()).append("\n");
            return buffer.toString();
        }

        private Route asRoute(String method, RouteMatcher matcher, List<MediaType> produces, Source source) {
            return new RouteImpl(this.filter, this, method, matcher.path(), produces, matcher.vars(), this.mapper, source);
        }
    }

    public static class Collection
    implements Props<Collection> {
        private final Props[] routes;

        public Collection(Props ... definitions) {
            this.routes = Objects.requireNonNull(definitions, "Route definitions are required.");
        }

        @Override
        public Collection name(String name) {
            for (Props definition : this.routes) {
                definition.name(name);
            }
            return this;
        }

        @Override
        public String renderer() {
            return this.routes[0].renderer();
        }

        @Override
        public Collection renderer(String name) {
            for (Props definition : this.routes) {
                definition.renderer(name);
            }
            return this;
        }

        @Override
        public Collection consumes(List<MediaType> types) {
            for (Props definition : this.routes) {
                definition.consumes(types);
            }
            return this;
        }

        @Override
        public Collection produces(List<MediaType> types) {
            for (Props definition : this.routes) {
                definition.produces(types);
            }
            return this;
        }

        @Override
        public Collection attr(String name, Object value) {
            for (Props definition : this.routes) {
                definition.attr(name, value);
            }
            return this;
        }

        @Override
        public Collection excludes(List<String> excludes) {
            for (Props definition : this.routes) {
                definition.excludes(excludes);
            }
            return this;
        }

        @Override
        public Collection map(Mapper<?> mapper) {
            for (Props route : this.routes) {
                route.map(mapper);
            }
            return this;
        }
    }

    public static interface Props<T extends Props<T>> {
        @Nonnull
        public T attr(String var1, Object var2);

        @Nonnull
        public T renderer(String var1);

        @Nullable
        public String renderer();

        @Nonnull
        public T name(String var1);

        @Nonnull
        default public T consumes(MediaType ... consumes) {
            return this.consumes(Arrays.asList(consumes));
        }

        @Nonnull
        default public T consumes(String ... consumes) {
            return this.consumes(MediaType.valueOf(consumes));
        }

        @Nonnull
        public T consumes(List<MediaType> var1);

        @Nonnull
        default public T produces(MediaType ... produces) {
            return this.produces(Arrays.asList(produces));
        }

        @Nonnull
        default public T produces(String ... produces) {
            return this.produces(MediaType.valueOf(produces));
        }

        @Nonnull
        public T produces(List<MediaType> var1);

        @Nonnull
        default public T excludes(String ... excludes) {
            return this.excludes(Arrays.asList(excludes));
        }

        @Nonnull
        public T excludes(List<String> var1);

        @Nonnull
        public T map(Mapper<?> var1);
    }

    public static interface Mapper<T> {
        @Nonnull
        public static Mapper<Object> chain(Mapper it, Mapper next) {
            return Mapper.create(it.name() + ">" + next.name(), v -> next.map(it.map(v)));
        }

        @Nonnull
        public static <T> Mapper<T> create(final String name, final Throwing.Function<T, Object> fn) {
            return new Mapper<T>(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public Object map(T value) throws Throwable {
                    return fn.apply(value);
                }

                public String toString() {
                    return this.name();
                }
            };
        }

        @Nonnull
        default public String name() {
            String name = Optional.ofNullable(Strings.emptyToNull(this.getClass().getSimpleName())).orElseGet(() -> {
                String classname = this.getClass().getName();
                return classname.substring(classname.lastIndexOf(46) + 1);
            });
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
        }

        @Nonnull
        public Object map(T var1) throws Throwable;
    }

    public static interface Source {
        public static final Source BUILTIN = new Source(){

            @Override
            public int line() {
                return -1;
            }

            @Override
            public Optional<String> declaringClass() {
                return Optional.empty();
            }

            public String toString() {
                return "~builtin";
            }
        };

        public int line();

        @Nonnull
        public Optional<String> declaringClass();
    }
}

