/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.Cookie;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.Status;

public interface Response {
    public void download(String var1, InputStream var2) throws Throwable;

    default public void download(String location) throws Throwable {
        this.download(location, location);
    }

    public void download(String var1, String var2) throws Throwable;

    default public void download(File file) throws Throwable {
        this.download(file.getName(), file);
    }

    default public void download(String filename, File file) throws Throwable {
        this.length(file.length());
        this.download(filename, new FileInputStream(file));
    }

    @Nonnull
    default public Response cookie(String name, String value) {
        return this.cookie(new Cookie.Definition(name, value));
    }

    @Nonnull
    public Response cookie(Cookie.Definition var1);

    @Nonnull
    public Response cookie(Cookie var1);

    @Nonnull
    public Response clearCookie(String var1);

    @Nonnull
    public Mutant header(String var1);

    @Nonnull
    public Response header(String var1, Object var2);

    @Nonnull
    default public Response header(String name, Object ... values) {
        return this.header(name, ((ImmutableList.Builder)ImmutableList.builder().add(values)).build());
    }

    @Nonnull
    public Response header(String var1, Iterable<Object> var2);

    @Nonnull
    public Charset charset();

    @Nonnull
    public Response charset(Charset var1);

    @Nonnull
    public Response length(long var1);

    @Nonnull
    public Optional<MediaType> type();

    @Nonnull
    public Response type(MediaType var1);

    @Nonnull
    default public Response type(String type) {
        return this.type(MediaType.valueOf(type));
    }

    default public void send(@Nullable Object result) throws Throwable {
        if (result instanceof Result) {
            this.send((Result)result);
        } else if (result != null) {
            Result b = Results.with(result);
            this.status().ifPresent(b::status);
            this.type().ifPresent(b::type);
            this.send(b);
        } else {
            throw new NullPointerException("Response required.");
        }
    }

    public void send(Result var1) throws Throwable;

    default public void redirect(String location) throws Throwable {
        this.redirect(Status.FOUND, location);
    }

    public void redirect(Status var1, String var2) throws Throwable;

    @Nonnull
    public Optional<Status> status();

    @Nonnull
    public Response status(Status var1);

    @Nonnull
    default public Response status(int status) {
        return this.status(Status.valueOf(status));
    }

    public boolean committed();

    public void end();

    public void after(Route.After var1);

    public void complete(Route.Complete var1);

    public boolean isResetHeadersOnError();

    public void setResetHeadersOnError(boolean var1);

    public static class Forwarding
    implements Response {
        protected final Response rsp;

        public Forwarding(Response response) {
            this.rsp = Objects.requireNonNull(response, "A response is required.");
        }

        @Override
        public void download(String filename, InputStream stream) throws Throwable {
            this.rsp.download(filename, stream);
        }

        @Override
        public void download(File file) throws Throwable {
            this.rsp.download(file);
        }

        @Override
        public void download(String filename, File file) throws Throwable {
            this.rsp.download(filename, file);
        }

        @Override
        public void download(String filename) throws Throwable {
            this.rsp.download(filename);
        }

        @Override
        public void download(String filename, String location) throws Throwable {
            this.rsp.download(filename, location);
        }

        @Override
        public Response cookie(String name, String value) {
            this.rsp.cookie(name, value);
            return this;
        }

        @Override
        public Response cookie(Cookie cookie) {
            this.rsp.cookie(cookie);
            return this;
        }

        @Override
        public Response cookie(Cookie.Definition cookie) {
            this.rsp.cookie(cookie);
            return this;
        }

        @Override
        public Response clearCookie(String name) {
            this.rsp.clearCookie(name);
            return this;
        }

        @Override
        public Mutant header(String name) {
            return this.rsp.header(name);
        }

        @Override
        public Response header(String name, Object value) {
            this.rsp.header(name, value);
            return this;
        }

        @Override
        public Response header(String name, Object ... values) {
            this.rsp.header(name, values);
            return this;
        }

        @Override
        public Response header(String name, Iterable<Object> values) {
            this.rsp.header(name, values);
            return this;
        }

        @Override
        public Charset charset() {
            return this.rsp.charset();
        }

        @Override
        public Response charset(Charset charset) {
            this.rsp.charset(charset);
            return this;
        }

        @Override
        public Response length(long length) {
            this.rsp.length(length);
            return this;
        }

        @Override
        public Optional<MediaType> type() {
            return this.rsp.type();
        }

        @Override
        public Response type(MediaType type) {
            this.rsp.type(type);
            return this;
        }

        @Override
        public Response type(String type) {
            this.rsp.type(type);
            return this;
        }

        @Override
        public void send(Object result) throws Throwable {
            Response.super.send(result);
        }

        @Override
        public void send(Result result) throws Throwable {
            this.rsp.send(result);
        }

        @Override
        public void end() {
            this.rsp.end();
        }

        @Override
        public void redirect(String location) throws Throwable {
            this.rsp.redirect(location);
        }

        @Override
        public void redirect(Status status, String location) throws Throwable {
            this.rsp.redirect(status, location);
        }

        @Override
        public Optional<Status> status() {
            return this.rsp.status();
        }

        @Override
        public Response status(Status status) {
            this.rsp.status(status);
            return this;
        }

        @Override
        public Response status(int status) {
            this.rsp.status(status);
            return this;
        }

        @Override
        public boolean committed() {
            return this.rsp.committed();
        }

        @Override
        public void after(Route.After handler) {
            this.rsp.after(handler);
        }

        @Override
        public void complete(Route.Complete handler) {
            this.rsp.complete(handler);
        }

        public String toString() {
            return this.rsp.toString();
        }

        @Override
        public boolean isResetHeadersOnError() {
            return this.rsp.isResetHeadersOnError();
        }

        @Override
        public void setResetHeadersOnError(boolean value) {
            this.setResetHeadersOnError(value);
        }

        public static Response unwrap(Response rsp) {
            Objects.requireNonNull(rsp, "A response is required.");
            Response root = rsp;
            while (root instanceof Forwarding) {
                root = ((Forwarding)root).rsp;
            }
            return root;
        }
    }
}

