/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
implements Route.Handler {
    private static final String USER_AGENT = "User-Agent";
    private static final String REFERER = "Referer";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    private static final String DASH = "-";
    private static final char SP = ' ';
    private static final char BL = '[';
    private static final char BR = ']';
    private static final char Q = '\"';
    private static final char QUERY = '?';
    private static Function<Request, String> ANNON = req -> "-";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Function<Request, String> userId;
    private Consumer<String> logRecord = arg_0 -> ((Logger)this.log).info(arg_0);
    private Function<Long, String> df;
    private boolean latency;
    private boolean queryString;
    private boolean extended;

    public RequestLogger(Function<Request, String> userId) {
        this.userId = Objects.requireNonNull(userId, "User ID provider required.");
        this.dateFormatter(FORMATTER);
    }

    public RequestLogger() {
        this(ANNON);
    }

    @Override
    public void handle(Request req, Response rsp) throws Throwable {
        rsp.complete((ereq, ersp, x) -> {
            StringBuilder sb = new StringBuilder(256);
            long timestamp = req.timestamp();
            sb.append(req.ip());
            sb.append(' ').append(DASH).append(' ');
            sb.append(this.userId.apply(req));
            sb.append(' ');
            sb.append('[').append(this.df.apply(timestamp)).append(']');
            sb.append(' ');
            sb.append('\"').append(req.method());
            sb.append(' ');
            sb.append(req.path());
            if (this.queryString) {
                req.queryString().ifPresent(s2 -> sb.append('?').append((String)s2));
            }
            sb.append(' ');
            sb.append(req.protocol());
            sb.append('\"').append(' ');
            int status = ersp.status().orElse(Status.OK).value();
            sb.append(status);
            sb.append(' ');
            sb.append(ersp.header(CONTENT_LENGTH).value(DASH));
            if (this.extended) {
                sb.append(' ');
                sb.append('\"').append(req.header(REFERER).value(DASH)).append('\"').append(' ');
                sb.append('\"').append(req.header(USER_AGENT).value(DASH)).append('\"');
            }
            if (this.latency) {
                long now = System.currentTimeMillis();
                sb.append(' ');
                sb.append(now - timestamp);
            }
            this.logRecord.accept(sb.toString());
        });
    }

    public RequestLogger log(Consumer<String> log) {
        this.logRecord = Objects.requireNonNull(log, "Logger required.");
        return this;
    }

    public RequestLogger dateFormatter(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "Formatter required.");
        return this.dateFormatter((Long ts) -> formatter.format(Instant.ofEpochMilli(ts)));
    }

    public RequestLogger dateFormatter(Function<Long, String> formatter) {
        Objects.requireNonNull(formatter, "Formatter required.");
        this.df = formatter;
        return this;
    }

    public RequestLogger dateFormatter(ZoneId zoneId) {
        return this.dateFormatter(FORMATTER.withZone(zoneId));
    }

    public RequestLogger latency() {
        this.latency = true;
        return this;
    }

    public RequestLogger queryString() {
        this.queryString = true;
        return this;
    }

    public RequestLogger extended() {
        this.extended = true;
        return this;
    }
}

