/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jooby.Cookie;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.internal.handlers.FlashScopeHandler;

public class FlashScope
implements Jooby.Module {
    public static final String NAME = "flash";
    private Function<String, Map<String, String>> decoder = Cookie.URL_DECODER;
    private Function<Map<String, String>, String> encoder = Cookie.URL_ENCODER;
    private Optional<Cookie.Definition> cookie = Optional.empty();
    private String method = "*";
    private String path = "*";

    public FlashScope(Cookie.Definition cookie) {
        this.cookie = Optional.of(Objects.requireNonNull(cookie, "Cookie required."));
    }

    public FlashScope() {
    }

    @Override
    public void configure(Env env, Config conf, Binder binder) {
        Config $cookie = conf.getConfig("flash.cookie");
        String cpath = $cookie.getString("path");
        boolean chttp = $cookie.getBoolean("httpOnly");
        boolean csecure = $cookie.getBoolean("secure");
        Cookie.Definition cookie = this.cookie.orElseGet(() -> new Cookie.Definition($cookie.getString("name")));
        cookie.path(cookie.path().orElse(cpath)).httpOnly(cookie.httpOnly().orElse(chttp)).secure(cookie.secure().orElse(csecure));
        env.router().use(this.method, this.path, new FlashScopeHandler(cookie, this.decoder, this.encoder)).name("flash-scope");
    }
}

