/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.LifeCycle;
import org.jooby.Registry;
import org.jooby.Router;
import org.jooby.funzy.Throwing;

public interface Env
extends LifeCycle {
    public static final Builder DEFAULT = (config, router, locale) -> {
        Objects.requireNonNull(config, "Config required.");
        final String name = config.hasPath("application.env") ? config.getString("application.env") : "dev";
        return new Env(){
            private ServiceKey key;
            private ImmutableList.Builder start = ImmutableList.builder();
            private ImmutableList.Builder started = ImmutableList.builder();
            private ImmutableList.Builder shutdown = ImmutableList.builder();
            private Map xss = new HashMap();
            private Map globals = new HashMap();
            {
                this.key = new ServiceKey();
            }

            @Override
            public <T> Env set(Key<T> key, T value) {
                this.globals.put(key, value);
                return this;
            }

            @Override
            public <T> T unset(Key<T> key) {
                return (T)this.globals.remove(key);
            }

            @Override
            public <T> Optional<T> get(Key<T> key) {
                Object value = this.globals.get(key);
                return Optional.ofNullable(value);
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public ServiceKey serviceKey() {
                return this.key;
            }

            @Override
            public Router router() {
                if (router == null) {
                    throw new UnsupportedOperationException();
                }
                return router;
            }

            @Override
            public Config config() {
                return config;
            }

            @Override
            public Locale locale() {
                return locale;
            }

            public String toString() {
                return this.name();
            }

            @Override
            public List<Throwing.Consumer<Registry>> stopTasks() {
                return this.shutdown.build();
            }

            @Override
            public Env onStop(Throwing.Consumer<Registry> task) {
                this.shutdown.add(task);
                return this;
            }

            @Override
            public Env onStart(Throwing.Consumer<Registry> task) {
                this.start.add(task);
                return this;
            }

            @Override
            public LifeCycle onStarted(Throwing.Consumer<Registry> task) {
                this.started.add(task);
                return this;
            }

            @Override
            public List<Throwing.Consumer<Registry>> startTasks() {
                return this.start.build();
            }

            @Override
            public List<Throwing.Consumer<Registry>> startedTasks() {
                return this.started.build();
            }

            @Override
            public Map<String, Function<String, String>> xss() {
                return Collections.unmodifiableMap(this.xss);
            }

            @Override
            public Env xss(String name2, Function<String, String> escaper) {
                this.xss.put(Objects.requireNonNull(name2, "Name required."), Objects.requireNonNull(escaper, "Function required."));
                return this;
            }
        };
    };

    @Nonnull
    public String name();

    @Nonnull
    public Router router() throws UnsupportedOperationException;

    @Nonnull
    public Config config();

    @Nonnull
    public Locale locale();

    @Nonnull
    default public ServiceKey serviceKey() {
        return new ServiceKey();
    }

    @Nonnull
    default public String resolve(String text) {
        return this.resolver().resolve(text);
    }

    @Nonnull
    default public Resolver resolver() {
        return new Resolver().source(this.config());
    }

    @Nonnull
    default public <T> Optional<T> ifMode(String name, Supplier<T> fn) {
        if (this.name().equals(name)) {
            return Optional.of(fn.get());
        }
        return Optional.empty();
    }

    @Nonnull
    public Map<String, Function<String, String>> xss();

    @Nonnull
    default public Function<String, String> xss(String ... xss) {
        Map<String, Function<String, String>> fn = this.xss();
        BinaryOperator reduce = Function::andThen;
        return Arrays.asList(xss).stream().map(fn::get).filter(Objects::nonNull).reduce(Function.identity(), reduce);
    }

    @Nonnull
    public Env xss(String var1, Function<String, String> var2);

    @Nonnull
    public List<Throwing.Consumer<Registry>> startTasks();

    @Nonnull
    public List<Throwing.Consumer<Registry>> startedTasks();

    @Nonnull
    public List<Throwing.Consumer<Registry>> stopTasks();

    @Nonnull
    public <T> Env set(Key<T> var1, T var2);

    @Nonnull
    default public <T> Env set(Class<T> key, T value) {
        return this.set(Key.get(key), value);
    }

    @Nullable
    public <T> T unset(Key<T> var1);

    @Nonnull
    public <T> Optional<T> get(Key<T> var1);

    @Nonnull
    default public <T> Optional<T> get(Class<T> key) {
        return this.get(Key.get(key));
    }

    public static interface Builder {
        @Nonnull
        default public Env build(Config config) {
            return this.build(config, null, Locale.getDefault());
        }

        @Nonnull
        public Env build(Config var1, @Nullable Router var2, Locale var3);
    }

    public static class ServiceKey {
        private Map<Object, Integer> instances = new HashMap<Object, Integer>();

        public <T> void generate(Class<T> type, String name, Consumer<Key<T>> keys) {
            Integer c = this.instances.put(type, this.instances.getOrDefault(type, 0) + 1);
            if (c == null) {
                keys.accept(Key.get(type));
            }
            keys.accept(Key.get(type, (Annotation)Names.named(name)));
        }
    }

    public static class Resolver {
        private String startDelim = "${";
        private String endDelim = "}";
        private PropertySource source;
        private boolean ignoreMissing;

        public Resolver source(Map<String, Object> source) {
            return this.source(new MapSource(source));
        }

        public Resolver source(PropertySource source) {
            this.source = source;
            return this;
        }

        public Resolver source(Config source) {
            return this.source(new ConfigSource(source));
        }

        public Resolver delimiters(String start, String end) {
            this.startDelim = Objects.requireNonNull(start, "Start delimiter required.");
            this.endDelim = Objects.requireNonNull(end, "End delmiter required.");
            return this;
        }

        public Resolver ignoreMissing() {
            this.ignoreMissing = true;
            return this;
        }

        public String resolve(String text) {
            Objects.requireNonNull(text, "Text is required.");
            if (text.length() == 0) {
                return "";
            }
            BiFunction<Integer, BiFunction, RuntimeException> err = (start, ex) -> {
                String snapshot = text.substring(0, (int)start);
                int line = Splitter.on('\n').splitToList(snapshot).size();
                int column = start - snapshot.lastIndexOf(10);
                return (RuntimeException)ex.apply(line, column);
            };
            StringBuilder buffer = new StringBuilder();
            int offset = 0;
            int start2 = text.indexOf(this.startDelim);
            while (start2 >= 0) {
                String value;
                int end = text.indexOf(this.endDelim, start2 + this.startDelim.length());
                if (end == -1) {
                    throw err.apply(start2, (line, column) -> new IllegalArgumentException("found '" + this.startDelim + "' expecting '" + this.endDelim + "' at " + line + ":" + column));
                }
                buffer.append(text.substring(offset, start2));
                String key = text.substring(start2 + this.startDelim.length(), end);
                try {
                    value = this.source.get(key);
                }
                catch (NoSuchElementException x) {
                    if (this.ignoreMissing) {
                        value = text.substring(start2, end + this.endDelim.length());
                    }
                    throw err.apply(start2, (line, column) -> new NoSuchElementException("Missing " + this.startDelim + key + this.endDelim + " at " + line + ":" + column));
                }
                buffer.append((Object)value);
                offset = end + this.endDelim.length();
                start2 = text.indexOf(this.startDelim, offset);
            }
            if (buffer.length() == 0) {
                return text;
            }
            if (offset < text.length()) {
                buffer.append(text.substring(offset));
            }
            return buffer.toString();
        }
    }

    public static class MapSource
    implements PropertySource {
        private Map<String, Object> source;

        public MapSource(Map<String, Object> source) {
            this.source = source;
        }

        @Override
        public String get(String key) throws NoSuchElementException {
            Object value = this.source.get(key);
            if (value != null) {
                return value.toString();
            }
            throw new NoSuchElementException(key);
        }
    }

    public static class ConfigSource
    implements PropertySource {
        private Config source;

        public ConfigSource(Config source) {
            this.source = source;
        }

        @Override
        public String get(String key) throws NoSuchElementException {
            if (this.source.hasPath(key)) {
                return this.source.getString(key);
            }
            throw new NoSuchElementException(key);
        }
    }

    public static interface PropertySource {
        @Nonnull
        public String get(String var1) throws NoSuchElementException;
    }
}

