/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.Request;
import org.jooby.Result;
import org.jooby.Route;

public class Deferred
extends Result {
    private Initializer initializer;
    private Handler handler;
    private String executor;
    private String callerThread;

    public Deferred(String executor, Initializer0 initializer) {
        this(executor, (Request req, Deferred deferred) -> initializer.run(deferred));
    }

    public Deferred(Initializer0 initializer) {
        this(null, initializer);
    }

    public Deferred(Initializer initializer) {
        this(null, initializer);
    }

    public Deferred(@Nullable String executor, Initializer initializer) {
        this.executor = executor;
        this.initializer = Objects.requireNonNull(initializer, "Initializer is required.");
        this.callerThread = Thread.currentThread().getName();
    }

    public Deferred() {
    }

    @Override
    @Nonnull
    public Result set(Object value) {
        if (value instanceof Throwable) {
            this.reject((Throwable)value);
        } else {
            this.resolve(value);
        }
        return this;
    }

    @Nonnull
    public Optional<String> executor() {
        return Optional.ofNullable(this.executor);
    }

    @Nonnull
    public String callerThread() {
        return this.callerThread;
    }

    public void resolve(@Nullable Object value) {
        if (value == null) {
            this.handler.handle(null, null);
        } else {
            Result result;
            if (value instanceof Result) {
                super.set(value);
                result = (Result)value;
            } else {
                super.set(value);
                result = this.clone();
            }
            this.handler.handle(result, null);
        }
    }

    public void reject(Throwable cause) {
        super.set(cause);
        this.handler.handle(null, cause);
    }

    public void handler(Request req, Handler handler) throws Exception {
        this.handler = Objects.requireNonNull(handler, "Handler is required.");
        if (this.initializer != null) {
            this.initializer.run(req, this);
        }
    }

    @Nonnull
    public static Deferred deferred(Route.OneArgHandler handler) {
        return Deferred.deferred(null, handler);
    }

    @Nonnull
    public static Deferred deferred(Route.ZeroArgHandler handler) {
        return Deferred.deferred(null, handler);
    }

    @Nonnull
    public static Deferred deferred(String executor, Route.ZeroArgHandler handler) {
        return Deferred.deferred(executor, (Request req) -> handler.handle());
    }

    @Nonnull
    public static Deferred deferred(String executor, Route.OneArgHandler handler) {
        return new Deferred(executor, (req, deferred) -> {
            try {
                deferred.resolve(handler.handle(req));
            }
            catch (Throwable x) {
                deferred.reject(x);
            }
        });
    }

    public static interface Handler {
        public void handle(@Nullable Result var1, Throwable var2);
    }

    public static interface Initializer {
        public void run(Request var1, Deferred var2) throws Exception;
    }

    public static interface Initializer0 {
        public void run(Deferred var1) throws Exception;
    }
}

