/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class BooleanMethodPropertyWriter
extends OptimizedBeanPropertyWriter<BooleanMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final boolean _suppressableSet;
    private final boolean _suppressableBoolean;

    public BooleanMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue instanceof Boolean) {
            this._suppressableBoolean = (Boolean)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableBoolean = false;
            this._suppressableSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new BooleanMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public BooleanMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new BooleanMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean, this._propertyIndex);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeFieldName(this._fastName);
            gen.writeBoolean(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean, this._propertyIndex);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, true);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeBoolean(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

