/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.entity.Entity;

@JsonDeserialize(builder=Builder.class)
public class EntityImp
implements Entity {
    protected DateTime createdDate;
    protected UUID id;
    protected DateTime updatedDate;

    public EntityImp(EntityImp that) {
        this.createdDate = that.createdDate;
        this.id = that.id;
        this.updatedDate = that.updatedDate;
    }

    protected EntityImp(Builder<?> builder) {
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.updatedDate = builder.updatedDate;
    }

    protected EntityImp() {
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityImp that = (EntityImp)o;
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected DateTime createdDate;
        protected UUID id;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.createdDate = that.createdDate;
            this.id = that.id;
            this.updatedDate = that.updatedDate;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(Entity that) {
            this.createdDate = that.getCreatedDate();
            this.id = that.getId();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public EntityImp build() {
            return new EntityImp(this.validate());
        }
    }
}

