/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.util.callcontext.TenantContext;

@JsonDeserialize(builder=Builder.class)
public class TenantContextImp
implements TenantContext {
    protected UUID accountId;
    protected UUID tenantId;

    public TenantContextImp(TenantContextImp that) {
        this.accountId = that.accountId;
        this.tenantId = that.tenantId;
    }

    protected TenantContextImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.tenantId = builder.tenantId;
    }

    protected TenantContextImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantContextImp that = (TenantContextImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        return Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.tenantId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("tenantId=").append(this.tenantId);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected UUID tenantId;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.tenantId = that.tenantId;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return (T)this;
        }

        public T source(TenantContext that) {
            this.accountId = that.getAccountId();
            this.tenantId = that.getTenantId();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TenantContextImp build() {
            return new TenantContextImp(this.validate());
        }
    }
}

