/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.usage.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.usage.api.RolledUpUnit;
import org.killbill.billing.usage.api.RolledUpUsage;

@JsonDeserialize(builder=Builder.class)
public class RolledUpUsageImp
implements RolledUpUsage {
    protected LocalDate end;
    protected List<RolledUpUnit> rolledUpUnits;
    protected LocalDate start;
    protected UUID subscriptionId;

    public RolledUpUsageImp(RolledUpUsageImp that) {
        this.end = that.end;
        this.rolledUpUnits = that.rolledUpUnits;
        this.start = that.start;
        this.subscriptionId = that.subscriptionId;
    }

    protected RolledUpUsageImp(Builder<?> builder) {
        this.end = builder.end;
        this.rolledUpUnits = builder.rolledUpUnits;
        this.start = builder.start;
        this.subscriptionId = builder.subscriptionId;
    }

    protected RolledUpUsageImp() {
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public List<RolledUpUnit> getRolledUpUnits() {
        return this.rolledUpUnits;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolledUpUsageImp that = (RolledUpUsageImp)o;
        if (this.end != null ? 0 != this.end.compareTo(that.end) : that.end != null) {
            return false;
        }
        if (!Objects.equals(this.rolledUpUnits, that.rolledUpUnits)) {
            return false;
        }
        if (this.start != null ? 0 != this.start.compareTo(that.start) : that.start != null) {
            return false;
        }
        return Objects.equals(this.subscriptionId, that.subscriptionId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.end);
        result = 31 * result + Objects.hashCode(this.rolledUpUnits);
        result = 31 * result + Objects.hashCode(this.start);
        result = 31 * result + Objects.hashCode(this.subscriptionId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("end=").append(this.end);
        sb.append(", ");
        sb.append("rolledUpUnits=").append(this.rolledUpUnits);
        sb.append(", ");
        sb.append("start=").append(this.start);
        sb.append(", ");
        sb.append("subscriptionId=").append(this.subscriptionId);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected LocalDate end;
        protected List<RolledUpUnit> rolledUpUnits;
        protected LocalDate start;
        protected UUID subscriptionId;

        public Builder() {
        }

        public Builder(Builder that) {
            this.end = that.end;
            this.rolledUpUnits = that.rolledUpUnits;
            this.start = that.start;
            this.subscriptionId = that.subscriptionId;
        }

        public T withEnd(LocalDate end) {
            this.end = end;
            return (T)this;
        }

        public T withRolledUpUnits(List<RolledUpUnit> rolledUpUnits) {
            this.rolledUpUnits = rolledUpUnits;
            return (T)this;
        }

        public T withStart(LocalDate start) {
            this.start = start;
            return (T)this;
        }

        public T withSubscriptionId(UUID subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (T)this;
        }

        public T source(RolledUpUsage that) {
            this.end = that.getEnd();
            this.rolledUpUnits = that.getRolledUpUnits();
            this.start = that.getStart();
            this.subscriptionId = that.getSubscriptionId();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public RolledUpUsageImp build() {
            return new RolledUpUsageImp(this.validate());
        }
    }
}

