/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util.http;

import java.io.UnsupportedEncodingException;

public final class UTF8UrlDecoder {
    private UTF8UrlDecoder() {
    }

    public static CharSequence decode(String s2) {
        return UTF8UrlDecoder.decode(s2, 0, s2.length());
    }

    static CharSequence decode(String s2, int offset, int length) {
        int initialSbLength = length > 500 ? length / 2 : length;
        StringBuilder sb = new StringBuilder(initialSbLength);
        int i = offset;
        int end = length + offset;
        byte[] bytes = null;
        while (i < end) {
            char c = s2.charAt(i);
            if (c == '+') {
                sb.append(' ');
                ++i;
                continue;
            }
            if (c == '%') {
                if (bytes == null) {
                    bytes = new byte[(end - i) / 3];
                }
                int pos = 0;
                while (i + 2 < end && c == '%') {
                    int v = Integer.parseInt(s2.substring(i + 1, i + 3), 16);
                    if (v < 0) {
                        throw new IllegalArgumentException("UTF8UrlDecoder: Illegal hex characters in escape (%) pattern - negative value");
                    }
                    bytes[pos++] = (byte)v;
                    if ((i += 3) >= end) continue;
                    c = s2.charAt(i);
                }
                if (i < end && c == '%') {
                    throw new IllegalArgumentException("UTF8UrlDecoder: Incomplete trailing escape (%) pattern");
                }
                try {
                    sb.append(new String(bytes, 0, pos, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

