/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.BillingExceptionBase;

public class ExceptionResponse {
    private final String className;
    private final Integer code;
    private final String message;
    private final String causeClassName;
    private final String causeMessage;
    private final List<StackTraceElementJson> stackTrace;

    @JsonCreator
    public ExceptionResponse(@JsonProperty(value="className") String className, @JsonProperty(value="code") @Nullable Integer code, @JsonProperty(value="message") String message, @JsonProperty(value="causeClassName") String causeClassName, @JsonProperty(value="causeMessage") String causeMessage, @JsonProperty(value="stackTrace") List<StackTraceElementJson> stackTrace) {
        this.className = className;
        this.code = code;
        this.message = message;
        this.causeClassName = causeClassName;
        this.causeMessage = causeMessage;
        this.stackTrace = stackTrace;
    }

    public ExceptionResponse(Exception exception, boolean withStackTrace) {
        this(exception.getClass().getName(), exception instanceof BillingExceptionBase ? Integer.valueOf(((BillingExceptionBase)exception).getCode()) : null, exception.getLocalizedMessage(), exception.getCause() == null ? null : exception.getCause().getClass().getName(), exception.getCause() == null ? null : exception.getCause().getLocalizedMessage(), !withStackTrace ? ImmutableList.of() : Lists.transform(ImmutableList.copyOf(exception.getStackTrace()), input -> new StackTraceElementJson(input.getClassName(), input.getFileName(), input.getLineNumber(), input.getMethodName(), input.isNativeMethod())));
    }

    public ExceptionResponse(String message) {
        this(null, null, message, null, null, null);
    }

    public String getClassName() {
        return this.className;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCauseClassName() {
        return this.causeClassName;
    }

    public String getCauseMessage() {
        return this.causeMessage;
    }

    public List<StackTraceElementJson> getStackTrace() {
        return this.stackTrace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BillingExceptionJson{");
        sb.append("className='").append(this.className).append('\'');
        sb.append(", code=").append(this.code);
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", causeClassName='").append(this.causeClassName).append('\'');
        sb.append(", causeMessage='").append(this.causeMessage).append('\'');
        sb.append(", stackTrace='").append(this.stackTrace).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionResponse that = (ExceptionResponse)o;
        if (this.causeClassName != null ? !this.causeClassName.equals(that.causeClassName) : that.causeClassName != null) {
            return false;
        }
        if (this.causeMessage != null ? !this.causeMessage.equals(that.causeMessage) : that.causeMessage != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.stackTrace != null ? !this.stackTrace.equals(that.stackTrace) : that.stackTrace != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.causeClassName != null ? this.causeClassName.hashCode() : 0);
        result = 31 * result + (this.causeMessage != null ? this.causeMessage.hashCode() : 0);
        result = 31 * result + (this.stackTrace != null ? this.stackTrace.hashCode() : 0);
        return result;
    }

    public static final class StackTraceElementJson {
        private final String className;
        private final String fileName;
        private final Integer lineNumber;
        private final String methodName;
        private final Boolean nativeMethod;

        @JsonCreator
        public StackTraceElementJson(@JsonProperty(value="className") String className, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="lineNumber") Integer lineNumber, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="nativeMethod") Boolean nativeMethod) {
            this.className = className;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
            this.methodName = methodName;
            this.nativeMethod = nativeMethod;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Boolean getNativeMethod() {
            return this.nativeMethod;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("StackTraceElementJson{");
            sb.append("className='").append(this.className).append('\'');
            sb.append(", fileName='").append(this.fileName).append('\'');
            sb.append(", lineNumber=").append(this.lineNumber);
            sb.append(", methodName='").append(this.methodName).append('\'');
            sb.append(", nativeMethod=").append(this.nativeMethod);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackTraceElementJson that = (StackTraceElementJson)o;
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
                return false;
            }
            if (this.lineNumber != null ? !this.lineNumber.equals(that.lineNumber) : that.lineNumber != null) {
                return false;
            }
            if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
                return false;
            }
            return !(this.nativeMethod != null ? !this.nativeMethod.equals(that.nativeMethod) : that.nativeMethod != null);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.lineNumber != null ? this.lineNumber.hashCode() : 0);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + (this.nativeMethod != null ? this.nativeMethod.hashCode() : 0);
            return result;
        }
    }
}

