/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.resources;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Status;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillClock;
import org.killbill.billing.plugin.core.resources.ExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResource {
    private static final Logger logger = LoggerFactory.getLogger(BaseResource.class);
    protected final OSGIKillbillAPI osgiKillbillAPI;
    protected final OSGIKillbillClock osgiKillbillClock;

    public BaseResource(OSGIKillbillAPI osgiKillbillAPI, OSGIKillbillClock osgiKillbillClock) {
        this.osgiKillbillAPI = osgiKillbillAPI;
        this.osgiKillbillClock = osgiKillbillClock;
    }

    protected Result invalidRequest(String message) {
        return Results.with((Object)new ExceptionResponse(message), Status.BAD_REQUEST);
    }

    protected Result withExceptionHandling(Callable<Result> callable) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            logger.warn("Unable to process request", (Throwable)exception);
            return Results.with((Object)new ExceptionResponse(exception, true), Status.SERVER_ERROR);
        }
    }

    protected void login(String authHeader) throws UnsupportedEncodingException {
        if (authHeader == null) {
            return;
        }
        String[] authHeaderChunks = authHeader.split(" ");
        if (authHeaderChunks.length < 2) {
            return;
        }
        String credentials = new String(BaseEncoding.base64().decode(authHeaderChunks[1]), "UTF-8");
        int p = credentials.indexOf(":");
        if (p == -1) {
            return;
        }
        String login = credentials.substring(0, p).trim();
        String password = credentials.substring(p + 1).trim();
        this.osgiKillbillAPI.getSecurityApi().login((Object)login, (Object)password);
    }
}

