/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.killbill.billing.tenant.api.Tenant;

public class PluginServlet
extends HttpServlet {
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");
    protected static final String HDR_CREATED_BY = "X-Killbill-CreatedBy";
    protected static final String HDR_REASON = "X-Killbill-Reason";
    protected static final String HDR_COMMENT = "X-Killbill-Comment";
    protected static final String TEXT_PLAIN = "text/plain";
    protected static final String TEXT_CSV = "text/csv";
    protected static final String TEXT_HTML = "text/html";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String APPLICATION_JAVASCRIPT = "application/javascript";

    protected Matcher getPathMatcher(Pattern pattern, HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        Matcher matcher = pattern.matcher(pathInfo);
        return matcher.matches() ? matcher : null;
    }

    protected LocalDate getParameterAsLocalDate(String parameterName, ServletRequest req) {
        String parameter = req.getParameter(parameterName);
        return Strings.emptyToNull(parameter) != null ? DATE_FORMAT.parseLocalDate(parameter) : null;
    }

    protected String getCreatedBy(HttpServletRequest req) {
        return MoreObjects.firstNonNull(req.getHeader(HDR_CREATED_BY), req.getRemoteAddr());
    }

    protected String getReason(HttpServletRequest req) {
        return req.getHeader(HDR_REASON);
    }

    protected String getComment(HttpServletRequest req) {
        return MoreObjects.firstNonNull(req.getHeader(HDR_COMMENT), req.getRequestURI());
    }

    protected Tenant getTenant(ServletRequest req) {
        return (Tenant)req.getAttribute("killbill_tenant");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRequestData(ServletRequest req) throws IOException {
        try (ServletInputStream inputStream = req.getInputStream();){
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream), Charsets.UTF_8);
            return string;
        }
    }

    protected void setTextContentType(ServletResponse resp) {
        resp.setContentType(TEXT_PLAIN);
    }

    protected void setCSVContentType(ServletResponse resp) {
        resp.setContentType(TEXT_CSV);
    }

    protected void setHtmlContentType(ServletResponse resp) {
        resp.setContentType(TEXT_HTML);
    }

    protected void setJsonContentType(ServletResponse resp) {
        resp.setContentType(APPLICATION_JSON);
    }

    protected void setXMLContentType(ServletResponse resp) {
        resp.setContentType(APPLICATION_XML);
    }

    protected void setJavascriptContentType(ServletResponse resp) {
        resp.setContentType(APPLICATION_JAVASCRIPT);
    }

    protected void setContentType(String contentType, ServletResponse resp) {
        resp.setContentType(contentType);
    }

    protected void buildOKResponse(byte[] data, HttpServletResponse resp) throws IOException {
        this.buildResponse(200, data, resp);
    }

    protected void buildCreatedResponse(String location, HttpServletResponse resp) throws IOException {
        resp.setHeader("Location", location);
        this.buildResponse(201, null, resp);
    }

    protected void buildResponse(HttpServletResponse resp) throws IOException {
        this.buildResponse(204, null, resp);
    }

    protected void buildResponse(int statusCode, @Nullable byte[] data, HttpServletResponse resp) throws IOException {
        if (data != null) {
            resp.getOutputStream().write(data);
        }
        resp.setStatus(statusCode);
    }

    protected void buildNotFoundResponse(String message, HttpServletResponse resp) throws IOException {
        resp.sendError(404, message);
    }

    protected void buildErrorResponse(Throwable throwable, HttpServletResponse resp) throws IOException {
        resp.sendError(500, throwable.getMessage());
    }
}

