/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.payment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.jooq.Table;
import org.jooq.UpdatableRecord;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.PaymentMethodInfoPlugin;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.payment.plugin.api.PaymentPluginApiException;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;
import org.killbill.billing.plugin.api.PluginApi;
import org.killbill.billing.plugin.api.PluginProperties;
import org.killbill.billing.plugin.dao.payment.PluginPaymentDao;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;

public abstract class PluginPaymentPluginApi<RESP_R extends UpdatableRecord<RESP_R>, RESP_T extends Table<RESP_R>, PM_R extends UpdatableRecord<PM_R>, PM_T extends Table<PM_R>>
extends PluginApi
implements PaymentPluginApi {
    public static final String PROPERTY_TOKEN = "token";
    public static final String PROPERTY_CC_NUMBER = "ccNumber";
    public static final String PROPERTY_CC_TYPE = "ccType";
    public static final String PROPERTY_CC_EXPIRATION_MONTH = "ccExpirationMonth";
    public static final String PROPERTY_CC_EXPIRATION_YEAR = "ccExpirationYear";
    public static final String PROPERTY_CC_START_MONTH = "ccStartMonth";
    public static final String PROPERTY_CC_START_YEAR = "ccStartYear";
    public static final String PROPERTY_CC_VERIFICATION_VALUE = "ccVerificationValue";
    public static final String PROPERTY_CC_ISSUE_NUMBER = "ccIssueNumber";
    public static final String PROPERTY_CC_FIRST_NAME = "ccFirstName";
    public static final String PROPERTY_CC_LAST_NAME = "ccLastName";
    public static final String PROPERTY_CC_TRACK_DATA = "ccTrackData";
    public static final String PROPERTY_ADDRESS1 = "address1";
    public static final String PROPERTY_ADDRESS2 = "address2";
    public static final String PROPERTY_CITY = "city";
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_ZIP = "zip";
    public static final String PROPERTY_COUNTRY = "country";
    public static final String PROPERTY_AMOUNT = "amount";
    public static final String PROPERTY_CURRENCY = "currency";
    protected final PluginPaymentDao<RESP_R, RESP_T, PM_R, PM_T> dao;

    public PluginPaymentPluginApi(OSGIKillbillAPI killbillAPI, OSGIConfigPropertiesService configProperties, Clock clock, PluginPaymentDao<RESP_R, RESP_T, PM_R, PM_T> dao) {
        super(killbillAPI, configProperties, clock);
        this.dao = dao;
    }

    protected abstract PaymentTransactionInfoPlugin buildPaymentTransactionInfoPlugin(RESP_R var1);

    protected abstract PaymentMethodPlugin buildPaymentMethodPlugin(PM_R var1);

    protected abstract PaymentMethodInfoPlugin buildPaymentMethodInfoPlugin(PM_R var1);

    protected abstract String getPaymentMethodId(PM_R var1);

    public List<PaymentTransactionInfoPlugin> getPaymentInfo(UUID kbAccountId, UUID kbPaymentId, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        List<RESP_R> records;
        try {
            records = this.dao.getResponses(kbPaymentId, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to retrieve payments for kbPaymentId " + kbPaymentId, (Throwable)e);
        }
        return Lists.transform(records, new Function<RESP_R, PaymentTransactionInfoPlugin>(){

            @Override
            public PaymentTransactionInfoPlugin apply(RESP_R record) {
                return PluginPaymentPluginApi.this.buildPaymentTransactionInfoPlugin(record);
            }
        });
    }

    public Pagination<PaymentTransactionInfoPlugin> searchPayments(String searchKey, Long offset, Long limit, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        throw new PaymentPluginApiException(null, "SEARCH: unsupported operation");
    }

    public void addPaymentMethod(UUID kbAccountId, UUID kbPaymentMethodId, PaymentMethodPlugin paymentMethodProps, boolean setDefault, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        Map<String, String> mergedProperties = PluginProperties.toStringMap(paymentMethodProps.getProperties(), properties);
        DateTime utcNow = this.clock.getUTCNow();
        try {
            this.dao.addPaymentMethod(kbAccountId, kbPaymentMethodId, setDefault, mergedProperties, utcNow, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to add payment method for kbPaymentMethodId " + kbPaymentMethodId, (Throwable)e);
        }
    }

    public void deletePaymentMethod(UUID kbAccountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        DateTime utcNow = this.clock.getUTCNow();
        try {
            this.dao.deletePaymentMethod(kbPaymentMethodId, utcNow, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to delete payment method for kbPaymentMethodId " + kbPaymentMethodId, (Throwable)e);
        }
    }

    public PaymentMethodPlugin getPaymentMethodDetail(UUID kbAccountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        PM_R record;
        try {
            record = this.dao.getPaymentMethod(kbPaymentMethodId, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to retrieve payment method for kbPaymentMethodId " + kbPaymentMethodId, (Throwable)e);
        }
        return this.buildPaymentMethodPlugin(record);
    }

    public void setDefaultPaymentMethod(UUID kbAccountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        DateTime utcNow = this.clock.getUTCNow();
        try {
            this.dao.setDefaultPaymentMethod(kbAccountId, kbPaymentMethodId, utcNow, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to set default payment method for kbPaymentMethodId " + kbPaymentMethodId, (Throwable)e);
        }
    }

    public List<PaymentMethodInfoPlugin> getPaymentMethods(UUID kbAccountId, boolean refreshFromGateway, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        List<PM_R> records;
        try {
            records = this.dao.getPaymentMethods(kbAccountId, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to retrieve payment methods for kbAccountId " + kbAccountId, (Throwable)e);
        }
        return Lists.transform(records, new Function<PM_R, PaymentMethodInfoPlugin>(){

            @Override
            public PaymentMethodInfoPlugin apply(PM_R record) {
                return PluginPaymentPluginApi.this.buildPaymentMethodInfoPlugin(record);
            }
        });
    }

    public Pagination<PaymentMethodPlugin> searchPaymentMethods(String searchKey, Long offset, Long limit, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        throw new PaymentPluginApiException(null, "SEARCH: unsupported operation");
    }

    public void resetPaymentMethods(UUID kbAccountId, List<PaymentMethodInfoPlugin> paymentMethods, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        List<PM_R> records;
        try {
            records = this.dao.getPaymentMethods(kbAccountId, context.getTenantId());
        }
        catch (SQLException e) {
            throw new PaymentPluginApiException("Unable to retrieve payment methods for kbAccountId " + kbAccountId, (Throwable)e);
        }
        ImmutableSet existingPaymentMethodIds = ImmutableSet.copyOf(Iterables.transform(records, new Function<PM_R, UUID>(){

            @Override
            public UUID apply(PM_R input) {
                return UUID.fromString(PluginPaymentPluginApi.this.getPaymentMethodId(input));
            }
        }));
        DateTime utcNow = this.clock.getUTCNow();
        for (PaymentMethodInfoPlugin existingPaymentMethod : paymentMethods) {
            if (existingPaymentMethodIds.contains(existingPaymentMethod.getPaymentMethodId())) continue;
            try {
                this.dao.addPaymentMethod(kbAccountId, existingPaymentMethod.getPaymentMethodId(), existingPaymentMethod.isDefault(), PluginProperties.toStringMap(properties), utcNow, context.getTenantId());
            }
            catch (SQLException e) {
                throw new PaymentPluginApiException("Unable to add payment method for kbPaymentMethodId " + existingPaymentMethod.getPaymentMethodId(), (Throwable)e);
            }
        }
    }
}

