/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.notification;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class PluginTenantConfigurable<C> {
    private static final String MONO_TENANT = "MONO_TENANT";
    private final Map<String, C> perTenantConfigurable = new ConcurrentHashMap<String, C>();
    private C defaultConfigurable;

    public PluginTenantConfigurable() {
        this(null);
    }

    public PluginTenantConfigurable(@Nullable C defaultConfigurable) {
        this.defaultConfigurable = defaultConfigurable;
    }

    public C getDefaultConfigurable() {
        return this.defaultConfigurable;
    }

    public void setDefaultConfigurable(C defaultConfigurable) {
        this.defaultConfigurable = defaultConfigurable;
    }

    public C get(@Nullable UUID kbTenantId) {
        String key = this.getKey(kbTenantId);
        C configurableForTenant = this.perTenantConfigurable.get(key);
        return MoreObjects.firstNonNull(configurableForTenant, this.defaultConfigurable);
    }

    public void put(@Nullable UUID kbTenantId, @Nullable C configurableForTenant) {
        String key = this.getKey(kbTenantId);
        C oldConfigurable = configurableForTenant == null && this.defaultConfigurable == null ? this.perTenantConfigurable.remove(key) : this.perTenantConfigurable.put(key, MoreObjects.firstNonNull(configurableForTenant, this.defaultConfigurable));
        if (oldConfigurable != null && oldConfigurable instanceof Closeable && oldConfigurable != this.defaultConfigurable) {
            try {
                ((Closeable)oldConfigurable).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getKey(@Nullable UUID kbTenantId) {
        return kbTenantId == null ? MONO_TENANT : kbTenantId.toString();
    }
}

