/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.invoice;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.boilerplate.InvoiceItemImp;

@JsonDeserialize(builder=Builder.class)
public class PluginInvoiceItem
extends InvoiceItemImp {
    public static PluginInvoiceItem createTaxItem(InvoiceItem model, UUID invoiceId, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, model.getStartDate(), model.getEndDate(), amount, description, InvoiceItemType.TAX);
    }

    public static PluginInvoiceItem createTaxItem(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, startDate, endDate, amount, description, InvoiceItemType.TAX);
    }

    public static PluginInvoiceItem createAdjustmentItem(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, startDate, endDate, amount, description, InvoiceItemType.ITEM_ADJ);
    }

    public static PluginInvoiceItem create(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description, InvoiceItemType invoiceItemType) {
        return new PluginInvoiceItem(UUID.randomUUID(), invoiceItemType, invoiceId, model.getAccountId(), model.getChildAccountId(), startDate, endDate, amount, model.getCurrency(), description, model.getSubscriptionId(), model.getBundleId(), model.getCatalogEffectiveDate(), model.getProductName(), model.getPrettyProductName(), model.getPlanName(), model.getPrettyPlanName(), model.getPhaseName(), model.getPrettyPhaseName(), model.getRate(), model.getId(), model.getUsageName(), model.getPrettyUsageName(), model.getQuantity(), model.getItemDetails(), model.getCreatedDate(), model.getUpdatedDate());
    }

    public PluginInvoiceItem(UUID id, InvoiceItemType invoiceItemType, UUID invoiceId, UUID accountId, UUID childAccountId, LocalDate startDate, LocalDate endDate, BigDecimal amount, Currency currency, String description, UUID subscriptionId, UUID bundleId, DateTime catalogEffectiveDate, String productName, String prettyProductName, String planName, String prettyPlanName, String phaseName, String prettyPhaseName, BigDecimal rate, UUID linkedItemId, String usageName, String prettyUsageName, Integer quantity, String itemDetails, DateTime createdDate, DateTime updatedDate) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().withId(id)).withInvoiceItemType(invoiceItemType)).withInvoiceId(invoiceId)).withAccountId(accountId)).withChildAccountId(childAccountId)).withStartDate(startDate)).withEndDate(endDate)).withAmount(amount)).withCurrency(currency)).withDescription(description)).withSubscriptionId(subscriptionId)).withBundleId(bundleId)).withCatalogEffectiveDate(catalogEffectiveDate)).withProductName(productName)).withPrettyProductName(prettyProductName)).withPlanName(planName)).withPrettyPlanName(prettyPlanName)).withPhaseName(phaseName)).withPrettyPhaseName(prettyPhaseName)).withRate(rate)).withLinkedItemId(linkedItemId)).withUsageName(usageName)).withPrettyUsageName(prettyUsageName)).withQuantity(quantity)).withItemDetails(itemDetails)).withCreatedDate(createdDate)).withUpdatedDate(updatedDate)).validate());
    }

    protected PluginInvoiceItem(Builder<?> builder) {
        super(builder);
    }

    public PluginInvoiceItem(PluginInvoiceItem that) {
        super(that);
    }

    public static class Builder<T extends Builder<T>>
    extends InvoiceItemImp.Builder<T> {
        public Builder() {
        }

        public Builder(Builder that) {
            super(that);
        }

        @Override
        public Builder validate() {
            return this;
        }

        @Override
        public PluginInvoiceItem build() {
            return new PluginInvoiceItem(this.validate());
        }
    }
}

