/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.plugin.util.http.UTF8UrlDecoder;

public abstract class PluginProperties {
    public static Iterable<PluginProperty> merge(Iterable<PluginProperty> ... propertiesLists) {
        return PluginProperties.buildPluginProperties(PluginProperties.toMap(propertiesLists));
    }

    public static Iterable<PluginProperty> merge(@Nullable Map data, Iterable<PluginProperty> ... propertiesLists) {
        return PluginProperties.merge(PluginProperties.buildPluginProperties(data), PluginProperties.merge(propertiesLists));
    }

    public static Map<String, Object> toMap(Iterable<PluginProperty> ... propertiesLists) {
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        for (Iterable<PluginProperty> propertiesList : propertiesLists) {
            if (propertiesList == null) continue;
            for (PluginProperty pluginProperty : propertiesList) {
                if (pluginProperty.getKey() == null || pluginProperty.getValue() == null) continue;
                mergedProperties.put(pluginProperty.getKey(), pluginProperty.getValue());
            }
        }
        return mergedProperties;
    }

    public static Map<String, String> toStringMap(Iterable<PluginProperty> ... propertiesLists) {
        return Maps.transformValues(PluginProperties.toMap(propertiesLists), new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input == null ? null : input.toString();
            }
        });
    }

    public static String getValue(String pluginPropertyName, String fallbackValue, Iterable<PluginProperty> properties) {
        String pluginPropertyValue = PluginProperties.findPluginPropertyValue(pluginPropertyName, properties);
        return pluginPropertyValue == null ? fallbackValue : pluginPropertyValue;
    }

    public static String findPluginPropertyValue(final String pluginPropertyName, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        PluginProperty pluginProperty = Iterables.tryFind(properties, new Predicate<PluginProperty>(){

            @Override
            public boolean apply(PluginProperty input) {
                return input != null && pluginPropertyName.equals(input.getKey());
            }
        }).orNull();
        if (pluginProperty == null || pluginProperty.getValue() == null) {
            return null;
        }
        String pluginPropertyString = String.valueOf(pluginProperty.getValue());
        return Strings.isNullOrEmpty(pluginPropertyString) ? null : pluginPropertyString;
    }

    public static String findAndDecodePluginPropertyValue(String pluginPropertyName, @Nullable Iterable<PluginProperty> properties) {
        String undecodedValue = PluginProperties.findPluginPropertyValue(pluginPropertyName, properties);
        return undecodedValue == null ? null : UTF8UrlDecoder.decode(undecodedValue).toString();
    }

    public static Iterable<PluginProperty> findPluginProperties(final String key, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        return Iterables.filter(properties, new Predicate<PluginProperty>(){

            @Override
            public boolean apply(PluginProperty input) {
                return key != null && key.equals(input.getKey());
            }
        });
    }

    public static Iterable<PluginProperty> findPluginProperties(final Pattern keyPattern, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        return Iterables.filter(properties, new Predicate<PluginProperty>(){

            @Override
            public boolean apply(PluginProperty input) {
                return input != null && keyPattern.matcher(input.getKey()).matches();
            }
        });
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    public static List<PluginProperty> buildPluginProperties(@Nullable Map data) {
        ImmutableList.Builder propertiesBuilder = ImmutableList.builder();
        if (data != null) {
            for (Object key : data.keySet()) {
                if (key == null) continue;
                PluginProperty property = new PluginProperty(key.toString(), data.get(key), Boolean.valueOf(false));
                propertiesBuilder.add(property);
            }
        }
        return propertiesBuilder.build();
    }
}

