/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIServiceNotAvailable;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginApi {
    private static final Logger logger = LoggerFactory.getLogger(PluginApi.class);
    protected static final String ENTITLEMENT_SERVICE_NAME = "entitlement-service";
    protected static final String BILLING_SERVICE_NAME = "billing-service";
    protected static final String ENTITLEMENT_BILLING_SERVICE_NAME = "entitlement+billing-service";
    protected static final long INTERNAL_TENANT_RECORD_ID = 0L;
    protected static final Iterable<PluginProperty> PLUGIN_PROPERTIES = ImmutableList.of();
    protected final OSGIKillbillAPI killbillAPI;
    protected final OSGIConfigPropertiesService configProperties;
    protected final Clock clock;

    protected PluginApi(OSGIKillbillAPI killbillAPI, OSGIConfigPropertiesService configProperties, Clock clock) {
        this.killbillAPI = killbillAPI;
        this.configProperties = configProperties;
        this.clock = clock;
    }

    protected Long getTenantRecordId(TenantContext context) throws OSGIServiceNotAvailable {
        if (context.getTenantId() == null) {
            return 0L;
        }
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(context.getTenantId(), ObjectType.TENANT, context);
    }

    protected Account getAccount(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        AccountUserApi accountUserApi = this.getAccountUserApi();
        try {
            return accountUserApi.getAccountById(accountId, context);
        }
        catch (AccountApiException e) {
            logger.warn("Error retrieving account for id {}", (Object)accountId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected AccountAuditLogs getAccountAuditLogs(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        AuditUserApi auditUserApi = this.getAuditUserApi();
        return auditUserApi.getAccountAuditLogs(accountId, AuditLevel.MINIMAL, context);
    }

    protected AuditLog getAccountCreationAuditLog(UUID accountId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForAccount = accountAuditLogs.getAuditLogsForAccount();
        for (AuditLog auditLog : auditLogsForAccount) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Account creation audit log for id {}", (Object)accountId);
        return null;
    }

    protected Long getAccountRecordId(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(accountId, ObjectType.ACCOUNT, context);
    }

    protected List<SubscriptionBundle> getSubscriptionBundlesForAccount(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        SubscriptionApi subscriptionApi = this.getSubscriptionApi();
        try {
            return subscriptionApi.getSubscriptionBundlesForAccountId(accountId, context);
        }
        catch (SubscriptionApiException e) {
            logger.warn("Error retrieving bundles for account id {}", (Object)accountId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected SubscriptionBundle getLatestSubscriptionBundleForExternalKey(String bundleExternalKey, TenantContext context) throws OSGIServiceNotAvailable {
        SubscriptionApi subscriptionApi = this.getSubscriptionApi();
        try {
            List bundles = subscriptionApi.getSubscriptionBundlesForExternalKey(bundleExternalKey, context);
            if (bundles.isEmpty()) {
                throw new OSGIServiceNotAvailable("Unable to retrieve latest bundle for bundle external key " + bundleExternalKey);
            }
            return (SubscriptionBundle)bundles.get(bundles.size() - 1);
        }
        catch (SubscriptionApiException e) {
            logger.warn("Error retrieving bundles for bundle external key {}", (Object)bundleExternalKey, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected Long getBundleRecordId(UUID bundleId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(bundleId, ObjectType.BUNDLE, context);
    }

    protected AuditLog getBundleCreationAuditLog(UUID bundleId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForBundle = accountAuditLogs.getAuditLogsForBundle(bundleId);
        for (AuditLog auditLog : auditLogsForBundle) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Bundle creation audit log for id {}", (Object)bundleId);
        return null;
    }

    protected AuditLog getSubscriptionEventCreationAuditLog(UUID subscriptionEventId, ObjectType objectType, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForSubscriptionEvent = accountAuditLogs.getAuditLogs(objectType).getAuditLogs(subscriptionEventId);
        for (AuditLog auditLog : auditLogsForSubscriptionEvent) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Subscription event creation audit log for id {}", (Object)subscriptionEventId);
        return null;
    }

    protected Long getSubscriptionEventRecordId(UUID subscriptionEventId, ObjectType objectType, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(subscriptionEventId, objectType, context);
    }

    protected Iterable<SubscriptionEvent> getBlockingHistory(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        List<SubscriptionBundle> bundles = this.getSubscriptionBundlesForAccount(accountId, context);
        Iterable<SubscriptionEvent> subscriptionEvents = Iterables.concat(Iterables.transform(bundles, new Function<SubscriptionBundle, List<SubscriptionEvent>>(){

            @Override
            public List<SubscriptionEvent> apply(SubscriptionBundle bundle) {
                return bundle == null ? ImmutableList.of() : bundle.getTimeline().getSubscriptionEvents();
            }
        }));
        return Iterables.filter(subscriptionEvents, new Predicate<SubscriptionEvent>(){

            @Override
            public boolean apply(SubscriptionEvent event) {
                return event != null && event.getSubscriptionEventType() != null && ObjectType.BLOCKING_STATES.equals((Object)event.getSubscriptionEventType().getObjectType()) && !PluginApi.ENTITLEMENT_SERVICE_NAME.equals(event.getServiceName());
            }
        });
    }

    protected AuditLog getBlockingStateCreationAuditLog(UUID blockingStateId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForBlockingState = accountAuditLogs.getAuditLogsForBlockingState(blockingStateId);
        for (AuditLog auditLog : auditLogsForBlockingState) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Blocking state creation audit log for id {}", (Object)blockingStateId);
        return null;
    }

    protected Long getBlockingStateRecordId(UUID blockingStateId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(blockingStateId, ObjectType.BLOCKING_STATES, context);
    }

    protected AuditLog getInvoiceCreationAuditLog(UUID invoiceId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForInvoice = accountAuditLogs.getAuditLogsForInvoice(invoiceId);
        for (AuditLog auditLog : auditLogsForInvoice) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Invoice creation audit log for id {}", (Object)invoiceId);
        return null;
    }

    protected Long getInvoiceRecordId(UUID invoiceId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(invoiceId, ObjectType.INVOICE, context);
    }

    protected AuditLog getInvoiceItemCreationAuditLog(UUID invoiceItemId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForInvoiceItem = accountAuditLogs.getAuditLogsForInvoiceItem(invoiceItemId);
        for (AuditLog auditLog : auditLogsForInvoiceItem) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Invoice item creation audit log for id {}", (Object)invoiceItemId);
        return null;
    }

    protected Long getInvoiceItemRecordId(UUID invoiceItemId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(invoiceItemId, ObjectType.INVOICE_ITEM, context);
    }

    protected Collection<Invoice> getInvoicesByAccountId(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        InvoiceUserApi invoiceUserApi = this.getInvoiceUserApi();
        return invoiceUserApi.getInvoicesByAccount(accountId, false, false, context);
    }

    protected BigDecimal getAccountBalance(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        InvoiceUserApi invoiceUserApi = this.getInvoiceUserApi();
        return invoiceUserApi.getAccountBalance(accountId, context);
    }

    protected Plan getPlanFromInvoiceItem(InvoiceItem invoiceItem, TenantContext context) throws OSGIServiceNotAvailable {
        try {
            VersionedCatalog catalog = this.getCatalog(context);
            DateTime catalogEffectiveDate = MoreObjects.firstNonNull(invoiceItem.getCatalogEffectiveDate(), invoiceItem.getCreatedDate());
            return catalog.getVersion(catalogEffectiveDate.toDate()).findPlan(invoiceItem.getPlanName());
        }
        catch (CatalogApiException e) {
            logger.info("Unable to retrieve plan for invoice item {}", (Object)invoiceItem.getId(), (Object)e);
            return null;
        }
    }

    protected PlanPhase getPlanPhaseFromInvoiceItem(InvoiceItem invoiceItem, LocalDate subscriptionStartDate, TenantContext context) throws OSGIServiceNotAvailable {
        try {
            VersionedCatalog catalog = this.getCatalog(context);
            DateTime catalogEffectiveDate = MoreObjects.firstNonNull(invoiceItem.getCatalogEffectiveDate(), invoiceItem.getCreatedDate());
            return catalog.getVersion(catalogEffectiveDate.toDate()).findPhase(invoiceItem.getPhaseName());
        }
        catch (CatalogApiException e) {
            logger.info("Unable to retrieve phase for invoice item {}", (Object)invoiceItem.getId(), (Object)e);
            return null;
        }
    }

    protected VersionedCatalog getCatalog(TenantContext context) throws OSGIServiceNotAvailable {
        CatalogUserApi catalogUserApi = this.getCatalogUserApi();
        try {
            return catalogUserApi.getCatalog(null, context);
        }
        catch (CatalogApiException e) {
            logger.info("Unable to retrieve catalog for tenant {}", (Object)context.getTenantId(), (Object)e);
            return null;
        }
    }

    protected Map<UUID, List<InvoicePayment>> getAccountInvoicePayments(Iterable<Payment> payments, TenantContext context) throws OSGIServiceNotAvailable {
        InvoicePaymentApi invoicePaymentApi = this.getInvoicePaymentUserApi();
        HashMap<UUID, List<InvoicePayment>> allInvoicePaymentsByPaymentId = new HashMap<UUID, List<InvoicePayment>>();
        for (Payment payment : payments) {
            allInvoicePaymentsByPaymentId.put(payment.getId(), invoicePaymentApi.getInvoicePayments(payment.getId(), context));
        }
        return allInvoicePaymentsByPaymentId;
    }

    protected AuditLog getInvoicePaymentCreationAuditLog(UUID invoicePaymentId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForInvoicePayment = accountAuditLogs.getAuditLogsForInvoicePayment(invoicePaymentId);
        for (AuditLog auditLog : auditLogsForInvoicePayment) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Invoice payment creation audit log for id {}", (Object)invoicePaymentId);
        return null;
    }

    protected Long getInvoicePaymentRecordId(UUID invoicePaymentId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(invoicePaymentId, ObjectType.INVOICE_PAYMENT, context);
    }

    protected Collection<Payment> getPaymentsWithPluginInfoByAccountId(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        PaymentApi paymentApi = this.getPaymentUserApi();
        try {
            return paymentApi.getAccountPayments(accountId, true, false, PLUGIN_PROPERTIES, context);
        }
        catch (PaymentApiException e) {
            logger.warn("Error retrieving payments for account id {}", (Object)accountId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected List<PaymentMethod> getPaymentMethodsForAccount(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        PaymentApi paymentApi = this.getPaymentUserApi();
        try {
            return paymentApi.getAccountPaymentMethods(accountId, false, true, PLUGIN_PROPERTIES, context);
        }
        catch (PaymentApiException e) {
            logger.warn("Error retrieving payment methods for accountId {}", (Object)accountId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected PaymentMethod getPaymentMethod(UUID paymentMethodId, TenantContext context) throws OSGIServiceNotAvailable {
        PaymentApi paymentApi = this.getPaymentUserApi();
        try {
            return paymentApi.getPaymentMethodById(paymentMethodId, true, false, PLUGIN_PROPERTIES, context);
        }
        catch (PaymentApiException e) {
            logger.warn("Error retrieving payment method for paymentMethodId {}", (Object)paymentMethodId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
    }

    protected AuditLog getPaymentCreationAuditLog(UUID paymentId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForPayment = accountAuditLogs.getAuditLogsForPayment(paymentId);
        for (AuditLog auditLog : auditLogsForPayment) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find payment creation audit log for id {}", (Object)paymentId);
        return null;
    }

    protected PaymentTransaction getPaymentTransaction(UUID kbPaymentId, UUID kbTransactionId, TenantContext context) throws OSGIServiceNotAvailable {
        Payment payment;
        try {
            payment = this.getPaymentUserApi().getPayment(kbPaymentId, false, false, PLUGIN_PROPERTIES, context);
        }
        catch (PaymentApiException e) {
            logger.warn("Error retrieving payment for paymentId {}", (Object)kbPaymentId, (Object)e);
            throw new OSGIServiceNotAvailable((Throwable)e);
        }
        return this.getPaymentTransaction(kbTransactionId, payment);
    }

    protected PaymentTransaction getPaymentTransaction(final UUID kbTransactionId, Payment payment) throws OSGIServiceNotAvailable {
        return Iterables.find(payment.getTransactions(), new Predicate<PaymentTransaction>(){

            @Override
            public boolean apply(PaymentTransaction input) {
                return input != null && kbTransactionId.equals(input.getId());
            }
        });
    }

    protected Long getPaymentRecordId(UUID paymentId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(paymentId, ObjectType.PAYMENT, context);
    }

    protected Collection<CustomField> getFieldsForAccount(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        CustomFieldUserApi tagUserApi = this.getCustomFieldUserApi();
        return tagUserApi.getCustomFieldsForAccount(accountId, context);
    }

    protected AuditLog getFieldCreationAuditLog(UUID fieldId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForTag = accountAuditLogs.getAuditLogsForCustomField(fieldId);
        for (AuditLog auditLog : auditLogsForTag) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Field creation audit log for id {}", (Object)fieldId);
        return null;
    }

    protected Long getFieldRecordId(UUID fieldId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(fieldId, ObjectType.CUSTOM_FIELD, context);
    }

    protected Collection<Tag> getTagsForAccount(UUID accountId, TenantContext context) throws OSGIServiceNotAvailable {
        TagUserApi tagUserApi = this.getTagUserApi();
        return tagUserApi.getTagsForAccount(accountId, false, context);
    }

    protected List<TagDefinition> getTagDefinitions(TenantContext context) throws OSGIServiceNotAvailable {
        TagUserApi tagUserApi = this.getTagUserApi();
        return tagUserApi.getTagDefinitions(context);
    }

    protected AuditLog getTagCreationAuditLog(UUID tagId, AccountAuditLogs accountAuditLogs) throws OSGIServiceNotAvailable {
        List auditLogsForTag = accountAuditLogs.getAuditLogsForTag(tagId);
        for (AuditLog auditLog : auditLogsForTag) {
            if (!auditLog.getChangeType().equals((Object)ChangeType.INSERT)) continue;
            return auditLog;
        }
        logger.warn("Unable to find Tag creation audit log for id {}", (Object)tagId);
        return null;
    }

    protected Long getTagRecordId(UUID tagId, TenantContext context) throws OSGIServiceNotAvailable {
        RecordIdApi recordIdUserApi = this.getRecordIdUserApi();
        return recordIdUserApi.getRecordId(tagId, ObjectType.TAG, context);
    }

    protected AccountUserApi getAccountUserApi() throws OSGIServiceNotAvailable {
        AccountUserApi accountUserApi = this.killbillAPI.getAccountUserApi();
        if (accountUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving accountUserApi");
        }
        return accountUserApi;
    }

    protected SubscriptionApi getSubscriptionApi() throws OSGIServiceNotAvailable {
        SubscriptionApi subscriptionApi = this.killbillAPI.getSubscriptionApi();
        if (subscriptionApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving subscriptionApi");
        }
        return subscriptionApi;
    }

    protected InvoiceUserApi getInvoiceUserApi() throws OSGIServiceNotAvailable {
        InvoiceUserApi invoiceUserApi = this.killbillAPI.getInvoiceUserApi();
        if (invoiceUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving invoiceUserApi");
        }
        return invoiceUserApi;
    }

    protected CatalogUserApi getCatalogUserApi() throws OSGIServiceNotAvailable {
        CatalogUserApi catalogUserApi = this.killbillAPI.getCatalogUserApi();
        if (catalogUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving catalogUserApi");
        }
        return catalogUserApi;
    }

    protected PaymentApi getPaymentUserApi() throws OSGIServiceNotAvailable {
        PaymentApi paymentApi = this.killbillAPI.getPaymentApi();
        if (paymentApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving paymentApi");
        }
        return paymentApi;
    }

    protected InvoicePaymentApi getInvoicePaymentUserApi() throws OSGIServiceNotAvailable {
        InvoicePaymentApi invoicePaymentApi = this.killbillAPI.getInvoicePaymentApi();
        if (invoicePaymentApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving invoicePaymentApi");
        }
        return invoicePaymentApi;
    }

    protected CustomFieldUserApi getCustomFieldUserApi() throws OSGIServiceNotAvailable {
        CustomFieldUserApi fieldUserApi = this.killbillAPI.getCustomFieldUserApi();
        if (fieldUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving fieldUserApi");
        }
        return fieldUserApi;
    }

    protected TagUserApi getTagUserApi() throws OSGIServiceNotAvailable {
        TagUserApi tagUserApi = this.killbillAPI.getTagUserApi();
        if (tagUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving tagUserApi");
        }
        return tagUserApi;
    }

    protected RecordIdApi getRecordIdUserApi() throws OSGIServiceNotAvailable {
        RecordIdApi recordIdApi = this.killbillAPI.getRecordIdApi();
        if (recordIdApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving recordIdApi");
        }
        return recordIdApi;
    }

    protected AuditUserApi getAuditUserApi() throws OSGIServiceNotAvailable {
        AuditUserApi auditUserApi = this.killbillAPI.getAuditUserApi();
        if (auditUserApi == null) {
            throw new OSGIServiceNotAvailable("Error retrieving auditUserApi");
        }
        return auditUserApi;
    }
}

