/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;

@JsonDeserialize(builder=Builder.class)
public class PaymentMethodPluginImp
implements PaymentMethodPlugin {
    protected String externalPaymentMethodId;
    protected boolean isDefaultPaymentMethod;
    protected UUID kbPaymentMethodId;
    protected List<PluginProperty> properties;

    public PaymentMethodPluginImp(PaymentMethodPluginImp that) {
        this.externalPaymentMethodId = that.externalPaymentMethodId;
        this.isDefaultPaymentMethod = that.isDefaultPaymentMethod;
        this.kbPaymentMethodId = that.kbPaymentMethodId;
        this.properties = that.properties;
    }

    protected PaymentMethodPluginImp(Builder<?> builder) {
        this.externalPaymentMethodId = builder.externalPaymentMethodId;
        this.isDefaultPaymentMethod = builder.isDefaultPaymentMethod;
        this.kbPaymentMethodId = builder.kbPaymentMethodId;
        this.properties = builder.properties;
    }

    protected PaymentMethodPluginImp() {
    }

    public String getExternalPaymentMethodId() {
        return this.externalPaymentMethodId;
    }

    @JsonGetter(value="isDefaultPaymentMethod")
    public boolean isDefaultPaymentMethod() {
        return this.isDefaultPaymentMethod;
    }

    public UUID getKbPaymentMethodId() {
        return this.kbPaymentMethodId;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodPluginImp that = (PaymentMethodPluginImp)o;
        if (!Objects.equals(this.externalPaymentMethodId, that.externalPaymentMethodId)) {
            return false;
        }
        if (this.isDefaultPaymentMethod != that.isDefaultPaymentMethod) {
            return false;
        }
        if (!Objects.equals(this.kbPaymentMethodId, that.kbPaymentMethodId)) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.externalPaymentMethodId);
        result = 31 * result + Objects.hashCode(this.isDefaultPaymentMethod);
        result = 31 * result + Objects.hashCode(this.kbPaymentMethodId);
        result = 31 * result + Objects.hashCode(this.properties);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("externalPaymentMethodId=");
        if (this.externalPaymentMethodId == null) {
            sb.append(this.externalPaymentMethodId);
        } else {
            sb.append("'").append(this.externalPaymentMethodId).append("'");
        }
        sb.append(", ");
        sb.append("isDefaultPaymentMethod=").append(this.isDefaultPaymentMethod);
        sb.append(", ");
        sb.append("kbPaymentMethodId=").append(this.kbPaymentMethodId);
        sb.append(", ");
        sb.append("properties=").append(this.properties);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String externalPaymentMethodId;
        protected boolean isDefaultPaymentMethod;
        protected UUID kbPaymentMethodId;
        protected List<PluginProperty> properties;

        public Builder() {
        }

        public Builder(Builder that) {
            this.externalPaymentMethodId = that.externalPaymentMethodId;
            this.isDefaultPaymentMethod = that.isDefaultPaymentMethod;
            this.kbPaymentMethodId = that.kbPaymentMethodId;
            this.properties = that.properties;
        }

        public T withExternalPaymentMethodId(String externalPaymentMethodId) {
            this.externalPaymentMethodId = externalPaymentMethodId;
            return (T)this;
        }

        public T withIsDefaultPaymentMethod(boolean isDefaultPaymentMethod) {
            this.isDefaultPaymentMethod = isDefaultPaymentMethod;
            return (T)this;
        }

        public T withKbPaymentMethodId(UUID kbPaymentMethodId) {
            this.kbPaymentMethodId = kbPaymentMethodId;
            return (T)this;
        }

        public T withProperties(List<PluginProperty> properties) {
            this.properties = properties;
            return (T)this;
        }

        public T source(PaymentMethodPlugin that) {
            this.externalPaymentMethodId = that.getExternalPaymentMethodId();
            this.isDefaultPaymentMethod = that.isDefaultPaymentMethod();
            this.kbPaymentMethodId = that.getKbPaymentMethodId();
            this.properties = that.getProperties();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PaymentMethodPluginImp build() {
            return new PaymentMethodPluginImp(this.validate());
        }
    }
}

