/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.util.tag.ControlTagType;

@JsonDeserialize(builder=Builder.class)
public class OverdueConditionImp
implements OverdueCondition {
    protected ControlTagType exclusionControlTagType;
    protected ControlTagType inclusionControlTagType;
    protected Integer numberOfUnpaidInvoicesEqualsOrExceeds;
    protected PaymentResponse[] responseForLastFailedPaymentIn;
    protected Duration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    protected BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds;

    public OverdueConditionImp(OverdueConditionImp that) {
        this.exclusionControlTagType = that.exclusionControlTagType;
        this.inclusionControlTagType = that.inclusionControlTagType;
        this.numberOfUnpaidInvoicesEqualsOrExceeds = that.numberOfUnpaidInvoicesEqualsOrExceeds;
        this.responseForLastFailedPaymentIn = that.responseForLastFailedPaymentIn;
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = that.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    protected OverdueConditionImp(Builder<?> builder) {
        this.exclusionControlTagType = builder.exclusionControlTagType;
        this.inclusionControlTagType = builder.inclusionControlTagType;
        this.numberOfUnpaidInvoicesEqualsOrExceeds = builder.numberOfUnpaidInvoicesEqualsOrExceeds;
        this.responseForLastFailedPaymentIn = builder.responseForLastFailedPaymentIn;
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = builder.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = builder.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    protected OverdueConditionImp() {
    }

    public ControlTagType getExclusionControlTagType() {
        return this.exclusionControlTagType;
    }

    public ControlTagType getInclusionControlTagType() {
        return this.inclusionControlTagType;
    }

    public Integer getNumberOfUnpaidInvoicesEqualsOrExceeds() {
        return this.numberOfUnpaidInvoicesEqualsOrExceeds;
    }

    public PaymentResponse[] getResponseForLastFailedPaymentIn() {
        return this.responseForLastFailedPaymentIn;
    }

    public Duration getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() {
        return this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    }

    public BigDecimal getTotalUnpaidInvoiceBalanceEqualsOrExceeds() {
        return this.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdueConditionImp that = (OverdueConditionImp)o;
        if (!Objects.equals(this.exclusionControlTagType, that.exclusionControlTagType)) {
            return false;
        }
        if (!Objects.equals(this.inclusionControlTagType, that.inclusionControlTagType)) {
            return false;
        }
        if (!Objects.equals(this.numberOfUnpaidInvoicesEqualsOrExceeds, that.numberOfUnpaidInvoicesEqualsOrExceeds)) {
            return false;
        }
        if (!Arrays.deepEquals(this.responseForLastFailedPaymentIn, that.responseForLastFailedPaymentIn)) {
            return false;
        }
        if (!Objects.equals(this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds, that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds)) {
            return false;
        }
        return !(this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null ? 0 != this.totalUnpaidInvoiceBalanceEqualsOrExceeds.compareTo(that.totalUnpaidInvoiceBalanceEqualsOrExceeds) : that.totalUnpaidInvoiceBalanceEqualsOrExceeds != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.exclusionControlTagType);
        result = 31 * result + Objects.hashCode(this.inclusionControlTagType);
        result = 31 * result + Objects.hashCode(this.numberOfUnpaidInvoicesEqualsOrExceeds);
        result = 31 * result + Arrays.deepHashCode(this.responseForLastFailedPaymentIn);
        result = 31 * result + Objects.hashCode(this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds);
        result = 31 * result + Objects.hashCode(this.totalUnpaidInvoiceBalanceEqualsOrExceeds);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("exclusionControlTagType=").append(this.exclusionControlTagType);
        sb.append(", ");
        sb.append("inclusionControlTagType=").append(this.inclusionControlTagType);
        sb.append(", ");
        sb.append("numberOfUnpaidInvoicesEqualsOrExceeds=").append(this.numberOfUnpaidInvoicesEqualsOrExceeds);
        sb.append(", ");
        sb.append("responseForLastFailedPaymentIn=").append(Arrays.toString(this.responseForLastFailedPaymentIn));
        sb.append(", ");
        sb.append("timeSinceEarliestUnpaidInvoiceEqualsOrExceeds=").append(this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds);
        sb.append(", ");
        sb.append("totalUnpaidInvoiceBalanceEqualsOrExceeds=").append(this.totalUnpaidInvoiceBalanceEqualsOrExceeds);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected ControlTagType exclusionControlTagType;
        protected ControlTagType inclusionControlTagType;
        protected Integer numberOfUnpaidInvoicesEqualsOrExceeds;
        protected PaymentResponse[] responseForLastFailedPaymentIn;
        protected Duration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
        protected BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds;

        public Builder() {
        }

        public Builder(Builder that) {
            this.exclusionControlTagType = that.exclusionControlTagType;
            this.inclusionControlTagType = that.inclusionControlTagType;
            this.numberOfUnpaidInvoicesEqualsOrExceeds = that.numberOfUnpaidInvoicesEqualsOrExceeds;
            this.responseForLastFailedPaymentIn = that.responseForLastFailedPaymentIn;
            this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
            this.totalUnpaidInvoiceBalanceEqualsOrExceeds = that.totalUnpaidInvoiceBalanceEqualsOrExceeds;
        }

        public T withExclusionControlTagType(ControlTagType exclusionControlTagType) {
            this.exclusionControlTagType = exclusionControlTagType;
            return (T)this;
        }

        public T withInclusionControlTagType(ControlTagType inclusionControlTagType) {
            this.inclusionControlTagType = inclusionControlTagType;
            return (T)this;
        }

        public T withNumberOfUnpaidInvoicesEqualsOrExceeds(Integer numberOfUnpaidInvoicesEqualsOrExceeds) {
            this.numberOfUnpaidInvoicesEqualsOrExceeds = numberOfUnpaidInvoicesEqualsOrExceeds;
            return (T)this;
        }

        public T withResponseForLastFailedPaymentIn(PaymentResponse[] responseForLastFailedPaymentIn) {
            this.responseForLastFailedPaymentIn = responseForLastFailedPaymentIn;
            return (T)this;
        }

        public T withTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds(Duration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds) {
            this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
            return (T)this;
        }

        public T withTotalUnpaidInvoiceBalanceEqualsOrExceeds(BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds) {
            this.totalUnpaidInvoiceBalanceEqualsOrExceeds = totalUnpaidInvoiceBalanceEqualsOrExceeds;
            return (T)this;
        }

        public T source(OverdueCondition that) {
            this.exclusionControlTagType = that.getExclusionControlTagType();
            this.inclusionControlTagType = that.getInclusionControlTagType();
            this.numberOfUnpaidInvoicesEqualsOrExceeds = that.getNumberOfUnpaidInvoicesEqualsOrExceeds();
            this.responseForLastFailedPaymentIn = that.getResponseForLastFailedPaymentIn();
            this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = that.getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds();
            this.totalUnpaidInvoiceBalanceEqualsOrExceeds = that.getTotalUnpaidInvoiceBalanceEqualsOrExceeds();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public OverdueConditionImp build() {
            return new OverdueConditionImp(this.validate());
        }
    }
}

