/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.units.Duration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.killbill.billing.osgi.api.PluginStateChange;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class KPMWrapper {
    private static final Logger logger = LoggerFactory.getLogger(KPMWrapper.class);
    private static final String PROPERTY_PREFIX = "org.killbill.billing.plugin.kpm.";
    private static final ExecutorService executor = Executors.newCachedThreadPool(KPMWrapper.daemonThreadsNamed("kpm-%s"));
    private static final ImmutableSet<Integer> DEFAULT_SUCCESSFUL_EXIT_CODES = ImmutableSet.of(Integer.valueOf(0));
    private static final File DEFAULT_DIRECTORY = new File(".").getAbsoluteFile();
    private static final Duration COMMAND_TIMEOUT = new Duration(5.0, TimeUnit.MINUTES);
    private static final Joiner SPACE_JOINER = Joiner.on(" ");
    private final OSGIKillbillAPI killbillAPI;
    private final String adminUsername;
    private final String adminPassword;
    private final String kpmPath;
    private final String bundlesPath;
    private final String nexusUrl;
    private final String nexusRepository;
    private final AsyncHttpClient httpClient;

    public KPMWrapper(OSGIKillbillAPI killbillAPI, Properties properties) throws GeneralSecurityException {
        this.killbillAPI = killbillAPI;
        this.adminUsername = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.adminUsername"), "admin");
        this.adminPassword = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.adminPassword"), "password");
        this.kpmPath = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.kpmPath"), "kpm");
        this.bundlesPath = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.bundlesPath"), Paths.get("/var", "tmp", "bundles").toString());
        this.nexusUrl = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.nexusUrl"), "https://oss.sonatype.org");
        this.nexusRepository = MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.nexusRepository"), "releases");
        this.httpClient = this.buildAsyncHttpClient(Boolean.valueOf(MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.strictSSL"), "true")), Integer.parseInt(MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.readTimeoutSec"), "60")) * 1000, Integer.parseInt(MoreObjects.firstNonNull(properties.getProperty("org.killbill.billing.plugin.kpm.connectTimeoutSec"), "60")) * 1000);
    }

    public String getAvailablePlugins(String kbVersion, Boolean latest) {
        Path sha1File = Paths.get(this.bundlesPath, "sha1.yml");
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(this.kpmPath);
        commands.add("info");
        commands.add("--as-json");
        commands.add(latest != false ? "--force-download" : "--no-force-download");
        commands.add("--sha1-file=" + sha1File.toString());
        if (kbVersion != null) {
            commands.add("--version=" + kbVersion);
        }
        if (this.nexusUrl != null) {
            commands.add("--overrides=url:" + this.nexusUrl);
        }
        if (this.nexusRepository != null) {
            commands.add("--overrides=repository:" + this.nexusRepository);
        }
        return this.system(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void install(String pluginKey, String uri, String pluginVersion, String pluginType) throws IOException, ExecutionException, InterruptedException {
        logger.info("Installing pluginKey='{}', uri='{}', pluginVersion='{}', pluginType='{}'", new Object[]{pluginKey, uri, pluginVersion, pluginType});
        File downloadDir = Files.createTempDirectory("kpm-" + pluginKey, new FileAttribute[0]).toFile();
        String suffix = "ruby".equals(pluginType) ? "tar.gz" : "jar";
        String pluginName = String.format("%s-plugin-%s.%s", pluginKey, pluginVersion, suffix);
        File tmp = new File(downloadDir, pluginName);
        try {
            final FileOutputStream stream = new FileOutputStream(tmp);
            this.httpClient.prepareGet(uri).execute(new AsyncCompletionHandlerBase(){

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    stream.write(bodyPart.getBodyPartBytes());
                    return AsyncHandler.State.CONTINUE;
                }
            }).get();
            LinkedList<String> commands = new LinkedList<String>();
            commands.add(this.kpmPath);
            commands.add("ruby".equals(pluginType) ? "install_ruby_plugin" : "install_java_plugin");
            commands.add(pluginKey);
            commands.add("--from-source-file=" + tmp.toString());
            commands.add("--destination=" + this.bundlesPath);
            if (pluginVersion != null) {
                commands.add("--version=" + pluginVersion);
            }
            if (this.nexusUrl != null) {
                commands.add("--overrides=url:" + this.nexusUrl);
            }
            if (this.nexusRepository != null) {
                commands.add("--overrides=repository:" + this.nexusRepository);
            }
            this.system(commands);
            this.notifyFileSystemChange(PluginStateChange.NEW_VERSION, pluginKey, pluginVersion);
        }
        finally {
            tmp.delete();
        }
    }

    public void install(String pluginKey, String kbVersion, String pluginArtifactId, String pluginVersion, String pluginGroupId, String pluginPackaging, String pluginClassifier, String pluginType, boolean forceDownload) {
        logger.info("Installing pluginKey='{}', kbVersion='{}', pluginArtifactId='{}', pluginVersion='{}', pluginGroupId='{}', pluginPackaging='{}', pluginClassifier='{}', pluginType='{}', forceDownload='{}'", new Object[]{pluginKey, kbVersion, pluginArtifactId, pluginVersion, pluginGroupId, pluginPackaging, pluginClassifier, pluginType, forceDownload});
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(this.kpmPath);
        commands.add("ruby".equals(pluginType) ? "install_ruby_plugin" : "install_java_plugin");
        commands.add(pluginKey);
        commands.add("--destination=" + this.bundlesPath);
        commands.add(kbVersion);
        if (pluginArtifactId != null) {
            commands.add("--artifact_id=" + pluginArtifactId);
        }
        if (pluginGroupId != null) {
            commands.add("--group_id=" + pluginGroupId);
        }
        if (pluginVersion != null) {
            commands.add("--version=" + pluginVersion);
        }
        if (pluginPackaging != null) {
            commands.add("--packaging=" + pluginPackaging);
        }
        if (pluginClassifier != null) {
            commands.add("--classifier=" + pluginClassifier);
        }
        if (pluginVersion != null) {
            commands.add("--version=" + pluginVersion);
        }
        commands.add("--force_download=" + forceDownload);
        if (this.nexusUrl != null) {
            commands.add("--overrides=url:" + this.nexusUrl);
        }
        if (this.nexusRepository != null) {
            commands.add("--overrides=repository:" + this.nexusRepository);
        }
        this.system(commands);
        this.notifyFileSystemChange(PluginStateChange.NEW_VERSION, pluginKey, pluginVersion);
    }

    public void uninstall(String pluginKey, String pluginVersion) {
        logger.info("Uninstalling plugin='{}', version='{}'", (Object)pluginKey, (Object)pluginVersion);
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(this.kpmPath);
        commands.add("uninstall");
        commands.add(pluginKey);
        commands.add("--destination=" + this.bundlesPath);
        if (pluginVersion != null) {
            commands.add("--version=" + pluginVersion);
        }
        this.system(commands);
        this.notifyFileSystemChange(PluginStateChange.DISABLED, pluginKey, pluginVersion);
    }

    private AsyncHttpClient buildAsyncHttpClient(Boolean strictSSL, int readTimeoutMs, int connectTimeoutMs) throws GeneralSecurityException {
        DefaultAsyncHttpClientConfig.Builder cfg = new DefaultAsyncHttpClientConfig.Builder();
        cfg.setUserAgent("KillBill/kpm-plugin/1.0").setConnectTimeout(connectTimeoutMs).setReadTimeout(readTimeoutMs).setUseInsecureTrustManager(strictSSL == false);
        return new DefaultAsyncHttpClient(cfg.build());
    }

    private String system(List<String> commands) {
        try {
            Command commandToExecute = new Command(commands, DEFAULT_SUCCESSFUL_EXIT_CODES, DEFAULT_DIRECTORY, ImmutableMap.of(), COMMAND_TIMEOUT);
            logger.info("Executing: {}", (Object)SPACE_JOINER.join(commandToExecute.getCommand()));
            String commandOutput = commandToExecute.execute(executor).getCommandOutput();
            logger.info("Output: {}", (Object)commandOutput);
            return commandOutput;
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFileSystemChange(PluginStateChange newState, String pluginKey, String pluginVersion) {
        try {
            logger.info("Notifying Kill Bill: state='{}', pluginKey='{}', pluginVersion={}", new Object[]{newState, pluginKey, pluginVersion});
            this.killbillAPI.getSecurityApi().login((Object)this.adminUsername, (Object)this.adminPassword);
            this.killbillAPI.getPluginsInfoApi().notifyOfStateChanged(newState, pluginKey, null, pluginVersion, null);
        }
        finally {
            this.killbillAPI.getSecurityApi().logout();
        }
    }

    private static ThreadFactory daemonThreadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).setThreadFactory(new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader())).build();
    }

    private static class ContextClassLoaderThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;

        ContextClassLoaderThreadFactory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }
    }
}

