/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.killbill.billing.notification.plugin.api.BroadcastMetadata;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.notification.plugin.api.ExtBusEventType;
import org.killbill.billing.osgi.bundles.kpm.KPMWrapper;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.util.nodes.NodeCommandProperty;
import org.killbill.billing.util.nodes.PluginNodeCommandMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsListener
implements OSGIKillbillEventDispatcher.OSGIKillbillEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(EventsListener.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final KPMWrapper kpmWrapper;

    public EventsListener(KPMWrapper kpmWrapper) {
        this.kpmWrapper = kpmWrapper;
    }

    public void handleKillbillEvent(ExtBusEvent killbillEvent) {
        PluginNodeCommandMetadata nodeCommandMetadata;
        BroadcastMetadata broadcastMetadata;
        if (killbillEvent.getEventType() != ExtBusEventType.BROADCAST_SERVICE) {
            return;
        }
        if (killbillEvent.getMetaData() == null) {
            logger.debug("Ignoring BROADCAST_SERVICE event without metadata: {}", (Object)killbillEvent);
            return;
        }
        try {
            broadcastMetadata = objectMapper.readValue(killbillEvent.getMetaData(), new TypeReference<BroadcastMetadata>(){});
        }
        catch (IOException e) {
            logger.warn("Ignoring BROADCAST_SERVICE event with invalid broadcastMetadata: {}", (Object)killbillEvent, (Object)e);
            return;
        }
        String commandType = broadcastMetadata.getCommandType();
        if (!"INSTALL_PLUGIN".equals(commandType) && !"UNINSTALL_PLUGIN".equals(commandType)) {
            logger.debug("Ignoring BROADCAST_SERVICE event: {}", (Object)killbillEvent);
            return;
        }
        try {
            nodeCommandMetadata = objectMapper.readValue(broadcastMetadata.getEventJson(), new TypeReference<PluginNodeCommandMetadata>(){});
        }
        catch (IOException e) {
            logger.warn("Ignoring BROADCAST_SERVICE event with invalid nodeCommandMetadata: {}", (Object)killbillEvent, (Object)e);
            return;
        }
        if (Strings.isNullOrEmpty(nodeCommandMetadata.getPluginKey())) {
            logger.warn("Ignoring BROADCAST_SERVICE event with missing pluginKey: {}", (Object)killbillEvent);
            return;
        }
        if ("INSTALL_PLUGIN".equals(commandType)) {
            Map<String, String> props = this.toMap(nodeCommandMetadata.getProperties());
            String pluginType = props.get("pluginType");
            String pluginUri = props.get("pluginUri");
            if (pluginUri != null) {
                try {
                    this.kpmWrapper.install(nodeCommandMetadata.getPluginKey(), pluginUri, nodeCommandMetadata.getPluginVersion(), pluginType);
                }
                catch (Exception e) {
                    logger.warn("Unable to install plugin {}", (Object)nodeCommandMetadata.getPluginKey(), (Object)e);
                }
            } else {
                String kbVersion = MoreObjects.firstNonNull(props.get("kbVersion"), "LATEST");
                String pluginArtifactId = props.get("pluginArtifactId");
                String pluginGroupId = props.get("pluginGroupId");
                String pluginPackaging = props.get("pluginPackaging");
                String pluginClassifier = props.get("pluginClassifier");
                boolean forceDownload = "true".equals(props.get("forceDownload"));
                this.kpmWrapper.install(nodeCommandMetadata.getPluginKey(), kbVersion, pluginArtifactId, nodeCommandMetadata.getPluginVersion(), pluginGroupId, pluginPackaging, pluginClassifier, pluginType, forceDownload);
            }
        } else if ("UNINSTALL_PLUGIN".equals(commandType)) {
            this.kpmWrapper.uninstall(nodeCommandMetadata.getPluginKey(), nodeCommandMetadata.getPluginVersion());
        }
    }

    private Map<String, String> toMap(Iterable<NodeCommandProperty> properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NodeCommandProperty property : properties) {
            if (property.getKey() == null || property.getValue() == null || property.getValue().toString().isEmpty()) continue;
            map.put(property.getKey(), property.getValue().toString());
        }
        return map;
    }
}

