/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.jooby.json.Jackson;
import org.killbill.billing.osgi.api.OSGIKillbillRegistrar;
import org.killbill.billing.osgi.bundles.kpm.EventsListener;
import org.killbill.billing.osgi.bundles.kpm.KPMWrapper;
import org.killbill.billing.osgi.bundles.kpm.PluginsResource;
import org.killbill.billing.osgi.libs.killbill.KillbillActivatorBase;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.plugin.core.resources.jooby.PluginApp;
import org.killbill.billing.plugin.core.resources.jooby.PluginAppBuilder;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends KillbillActivatorBase {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_NAME = "killbill-kpm";
    private EventsListener eventsListener;

    public void start(BundleContext context) throws Exception {
        this.killbillAPI = new OSGIKillbillAPI(context);
        this.dispatcher = new OSGIKillbillEventDispatcher(context);
        this.configProperties = new OSGIConfigPropertiesService(context);
        this.registrar = new OSGIKillbillRegistrar();
        KPMWrapper kpmWrapper = new KPMWrapper(this.killbillAPI, this.configProperties.getProperties());
        this.eventsListener = new EventsListener(kpmWrapper);
        Jackson jackson = new Jackson(PluginAppBuilder.DEFAULT_OBJECT_MAPPER);
        jackson.raw();
        PluginApp pluginApp = new PluginAppBuilder(PLUGIN_NAME).withJackson(jackson).withService(kpmWrapper).withRouteClass(PluginsResource.class).build();
        HttpServlet httpServlet = PluginApp.createServlet(pluginApp);
        this.registerServlet(context, httpServlet);
        this.registerHandlers();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    private void registerHandlers() {
        this.dispatcher.registerEventHandlers(new OSGIKillbillEventDispatcher.OSGIHandlerMarker[]{() -> this.dispatcher.registerEventHandlers(new OSGIKillbillEventDispatcher.OSGIHandlerMarker[]{this.eventsListener})});
    }

    private void registerServlet(BundleContext context, HttpServlet servlet) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("killbill.pluginName", PLUGIN_NAME);
        this.registrar.registerService(context, Servlet.class, (Object)servlet, props);
    }
}

