/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.DryRunType;

@JsonDeserialize(builder=Builder.class)
public class DryRunArgumentsImp
implements DryRunArguments {
    protected SubscriptionEventType action;
    protected BillingActionPolicy billingActionPolicy;
    protected UUID bundleId;
    protected DryRunType dryRunType;
    protected LocalDate effectiveDate;
    protected EntitlementSpecifier entitlementSpecifier;
    protected UUID subscriptionId;

    public DryRunArgumentsImp(DryRunArgumentsImp that) {
        this.action = that.action;
        this.billingActionPolicy = that.billingActionPolicy;
        this.bundleId = that.bundleId;
        this.dryRunType = that.dryRunType;
        this.effectiveDate = that.effectiveDate;
        this.entitlementSpecifier = that.entitlementSpecifier;
        this.subscriptionId = that.subscriptionId;
    }

    protected DryRunArgumentsImp(Builder<?> builder) {
        this.action = builder.action;
        this.billingActionPolicy = builder.billingActionPolicy;
        this.bundleId = builder.bundleId;
        this.dryRunType = builder.dryRunType;
        this.effectiveDate = builder.effectiveDate;
        this.entitlementSpecifier = builder.entitlementSpecifier;
        this.subscriptionId = builder.subscriptionId;
    }

    protected DryRunArgumentsImp() {
    }

    public SubscriptionEventType getAction() {
        return this.action;
    }

    public BillingActionPolicy getBillingActionPolicy() {
        return this.billingActionPolicy;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public DryRunType getDryRunType() {
        return this.dryRunType;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public EntitlementSpecifier getEntitlementSpecifier() {
        return this.entitlementSpecifier;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DryRunArgumentsImp that = (DryRunArgumentsImp)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.billingActionPolicy, that.billingActionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.bundleId, that.bundleId)) {
            return false;
        }
        if (!Objects.equals(this.dryRunType, that.dryRunType)) {
            return false;
        }
        if (this.effectiveDate != null ? 0 != this.effectiveDate.compareTo(that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (!Objects.equals(this.entitlementSpecifier, that.entitlementSpecifier)) {
            return false;
        }
        return Objects.equals(this.subscriptionId, that.subscriptionId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.action);
        result = 31 * result + Objects.hashCode(this.billingActionPolicy);
        result = 31 * result + Objects.hashCode(this.bundleId);
        result = 31 * result + Objects.hashCode(this.dryRunType);
        result = 31 * result + Objects.hashCode(this.effectiveDate);
        result = 31 * result + Objects.hashCode(this.entitlementSpecifier);
        result = 31 * result + Objects.hashCode(this.subscriptionId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("action=").append(this.action);
        sb.append(", ");
        sb.append("billingActionPolicy=").append(this.billingActionPolicy);
        sb.append(", ");
        sb.append("bundleId=").append(this.bundleId);
        sb.append(", ");
        sb.append("dryRunType=").append(this.dryRunType);
        sb.append(", ");
        sb.append("effectiveDate=").append(this.effectiveDate);
        sb.append(", ");
        sb.append("entitlementSpecifier=").append(this.entitlementSpecifier);
        sb.append(", ");
        sb.append("subscriptionId=").append(this.subscriptionId);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected SubscriptionEventType action;
        protected BillingActionPolicy billingActionPolicy;
        protected UUID bundleId;
        protected DryRunType dryRunType;
        protected LocalDate effectiveDate;
        protected EntitlementSpecifier entitlementSpecifier;
        protected UUID subscriptionId;

        public Builder() {
        }

        public Builder(Builder that) {
            this.action = that.action;
            this.billingActionPolicy = that.billingActionPolicy;
            this.bundleId = that.bundleId;
            this.dryRunType = that.dryRunType;
            this.effectiveDate = that.effectiveDate;
            this.entitlementSpecifier = that.entitlementSpecifier;
            this.subscriptionId = that.subscriptionId;
        }

        public T withAction(SubscriptionEventType action) {
            this.action = action;
            return (T)this;
        }

        public T withBillingActionPolicy(BillingActionPolicy billingActionPolicy) {
            this.billingActionPolicy = billingActionPolicy;
            return (T)this;
        }

        public T withBundleId(UUID bundleId) {
            this.bundleId = bundleId;
            return (T)this;
        }

        public T withDryRunType(DryRunType dryRunType) {
            this.dryRunType = dryRunType;
            return (T)this;
        }

        public T withEffectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return (T)this;
        }

        public T withEntitlementSpecifier(EntitlementSpecifier entitlementSpecifier) {
            this.entitlementSpecifier = entitlementSpecifier;
            return (T)this;
        }

        public T withSubscriptionId(UUID subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (T)this;
        }

        public T source(DryRunArguments that) {
            this.action = that.getAction();
            this.billingActionPolicy = that.getBillingActionPolicy();
            this.bundleId = that.getBundleId();
            this.dryRunType = that.getDryRunType();
            this.effectiveDate = that.getEffectiveDate();
            this.entitlementSpecifier = that.getEntitlementSpecifier();
            this.subscriptionId = that.getSubscriptionId();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public DryRunArgumentsImp build() {
            return new DryRunArgumentsImp(this.validate());
        }
    }
}

