/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.entitlement.api.EntitlementAOStatusDryRun;

@JsonDeserialize(builder=Builder.class)
public class EntitlementAOStatusDryRunImp
implements EntitlementAOStatusDryRun {
    protected BillingPeriod billingPeriod;
    protected UUID id;
    protected PhaseType phaseType;
    protected String priceList;
    protected String productName;
    protected EntitlementAOStatusDryRun.DryRunChangeReason reason;

    public EntitlementAOStatusDryRunImp(EntitlementAOStatusDryRunImp that) {
        this.billingPeriod = that.billingPeriod;
        this.id = that.id;
        this.phaseType = that.phaseType;
        this.priceList = that.priceList;
        this.productName = that.productName;
        this.reason = that.reason;
    }

    protected EntitlementAOStatusDryRunImp(Builder<?> builder) {
        this.billingPeriod = builder.billingPeriod;
        this.id = builder.id;
        this.phaseType = builder.phaseType;
        this.priceList = builder.priceList;
        this.productName = builder.productName;
        this.reason = builder.reason;
    }

    protected EntitlementAOStatusDryRunImp() {
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public UUID getId() {
        return this.id;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public String getProductName() {
        return this.productName;
    }

    public EntitlementAOStatusDryRun.DryRunChangeReason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitlementAOStatusDryRunImp that = (EntitlementAOStatusDryRunImp)o;
        if (!Objects.equals(this.billingPeriod, that.billingPeriod)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.phaseType, that.phaseType)) {
            return false;
        }
        if (!Objects.equals(this.priceList, that.priceList)) {
            return false;
        }
        if (!Objects.equals(this.productName, that.productName)) {
            return false;
        }
        return Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billingPeriod);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.phaseType);
        result = 31 * result + Objects.hashCode(this.priceList);
        result = 31 * result + Objects.hashCode(this.productName);
        result = 31 * result + Objects.hashCode(this.reason);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billingPeriod=").append(this.billingPeriod);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("phaseType=").append(this.phaseType);
        sb.append(", ");
        sb.append("priceList=");
        if (this.priceList == null) {
            sb.append(this.priceList);
        } else {
            sb.append("'").append(this.priceList).append("'");
        }
        sb.append(", ");
        sb.append("productName=");
        if (this.productName == null) {
            sb.append(this.productName);
        } else {
            sb.append("'").append(this.productName).append("'");
        }
        sb.append(", ");
        sb.append("reason=").append(this.reason);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BillingPeriod billingPeriod;
        protected UUID id;
        protected PhaseType phaseType;
        protected String priceList;
        protected String productName;
        protected EntitlementAOStatusDryRun.DryRunChangeReason reason;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billingPeriod = that.billingPeriod;
            this.id = that.id;
            this.phaseType = that.phaseType;
            this.priceList = that.priceList;
            this.productName = that.productName;
            this.reason = that.reason;
        }

        public T withBillingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withPhaseType(PhaseType phaseType) {
            this.phaseType = phaseType;
            return (T)this;
        }

        public T withPriceList(String priceList) {
            this.priceList = priceList;
            return (T)this;
        }

        public T withProductName(String productName) {
            this.productName = productName;
            return (T)this;
        }

        public T withReason(EntitlementAOStatusDryRun.DryRunChangeReason reason) {
            this.reason = reason;
            return (T)this;
        }

        public T source(EntitlementAOStatusDryRun that) {
            this.billingPeriod = that.getBillingPeriod();
            this.id = that.getId();
            this.phaseType = that.getPhaseType();
            this.priceList = that.getPriceList();
            this.productName = that.getProductName();
            this.reason = that.getReason();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public EntitlementAOStatusDryRunImp build() {
            return new EntitlementAOStatusDryRunImp(this.validate());
        }
    }
}

