/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.currency.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Set;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.currency.api.CurrencyConversion;
import org.killbill.billing.currency.api.Rate;

@JsonDeserialize(builder=Builder.class)
public class CurrencyConversionImp
implements CurrencyConversion {
    protected Currency baseCurrency;
    protected Set<Rate> rates;

    public CurrencyConversionImp(CurrencyConversionImp that) {
        this.baseCurrency = that.baseCurrency;
        this.rates = that.rates;
    }

    protected CurrencyConversionImp(Builder<?> builder) {
        this.baseCurrency = builder.baseCurrency;
        this.rates = builder.rates;
    }

    protected CurrencyConversionImp() {
    }

    public Currency getBaseCurrency() {
        return this.baseCurrency;
    }

    public Set<Rate> getRates() {
        return this.rates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyConversionImp that = (CurrencyConversionImp)o;
        if (!Objects.equals(this.baseCurrency, that.baseCurrency)) {
            return false;
        }
        return Objects.equals(this.rates, that.rates);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.baseCurrency);
        result = 31 * result + Objects.hashCode(this.rates);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("baseCurrency=").append(this.baseCurrency);
        sb.append(", ");
        sb.append("rates=").append(this.rates);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency baseCurrency;
        protected Set<Rate> rates;

        public Builder() {
        }

        public Builder(Builder that) {
            this.baseCurrency = that.baseCurrency;
            this.rates = that.rates;
        }

        public T withBaseCurrency(Currency baseCurrency) {
            this.baseCurrency = baseCurrency;
            return (T)this;
        }

        public T withRates(Set<Rate> rates) {
            this.rates = rates;
            return (T)this;
        }

        public T source(CurrencyConversion that) {
            this.baseCurrency = that.getBaseCurrency();
            this.rates = that.getRates();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public CurrencyConversionImp build() {
            return new CurrencyConversionImp(this.validate());
        }
    }
}

