/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Price;

@JsonDeserialize(builder=Builder.class)
public class PriceImp
implements Price {
    protected Currency currency;
    protected BigDecimal value;

    public PriceImp(PriceImp that) {
        this.currency = that.currency;
        this.value = that.value;
    }

    protected PriceImp(Builder<?> builder) {
        this.currency = builder.currency;
        this.value = builder.value;
    }

    protected PriceImp() {
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceImp that = (PriceImp)o;
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        return !(this.value != null ? 0 != this.value.compareTo(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("value=").append(this.value);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency currency;
        protected BigDecimal value;

        public Builder() {
        }

        public Builder(Builder that) {
            this.currency = that.currency;
            this.value = that.value;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withValue(BigDecimal value) {
            this.value = value;
            return (T)this;
        }

        public T source(Price that) throws CurrencyValueNull {
            this.currency = that.getCurrency();
            this.value = that.getValue();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PriceImp build() {
            return new PriceImp(this.validate());
        }
    }
}

