/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.UsagePriceOverride;

@JsonDeserialize(builder=Builder.class)
public class PlanPhasePriceOverrideImp
implements PlanPhasePriceOverride {
    protected Currency currency;
    protected BigDecimal fixedPrice;
    protected String phaseName;
    protected PlanPhaseSpecifier planPhaseSpecifier;
    protected BigDecimal recurringPrice;
    protected List<UsagePriceOverride> usagePriceOverrides;

    public PlanPhasePriceOverrideImp(PlanPhasePriceOverrideImp that) {
        this.currency = that.currency;
        this.fixedPrice = that.fixedPrice;
        this.phaseName = that.phaseName;
        this.planPhaseSpecifier = that.planPhaseSpecifier;
        this.recurringPrice = that.recurringPrice;
        this.usagePriceOverrides = that.usagePriceOverrides;
    }

    protected PlanPhasePriceOverrideImp(Builder<?> builder) {
        this.currency = builder.currency;
        this.fixedPrice = builder.fixedPrice;
        this.phaseName = builder.phaseName;
        this.planPhaseSpecifier = builder.planPhaseSpecifier;
        this.recurringPrice = builder.recurringPrice;
        this.usagePriceOverrides = builder.usagePriceOverrides;
    }

    protected PlanPhasePriceOverrideImp() {
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public PlanPhaseSpecifier getPlanPhaseSpecifier() {
        return this.planPhaseSpecifier;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public List<UsagePriceOverride> getUsagePriceOverrides() {
        return this.usagePriceOverrides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanPhasePriceOverrideImp that = (PlanPhasePriceOverrideImp)o;
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (this.fixedPrice != null ? 0 != this.fixedPrice.compareTo(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (!Objects.equals(this.phaseName, that.phaseName)) {
            return false;
        }
        if (!Objects.equals(this.planPhaseSpecifier, that.planPhaseSpecifier)) {
            return false;
        }
        if (this.recurringPrice != null ? 0 != this.recurringPrice.compareTo(that.recurringPrice) : that.recurringPrice != null) {
            return false;
        }
        return Objects.equals(this.usagePriceOverrides, that.usagePriceOverrides);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.fixedPrice);
        result = 31 * result + Objects.hashCode(this.phaseName);
        result = 31 * result + Objects.hashCode(this.planPhaseSpecifier);
        result = 31 * result + Objects.hashCode(this.recurringPrice);
        result = 31 * result + Objects.hashCode(this.usagePriceOverrides);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("fixedPrice=").append(this.fixedPrice);
        sb.append(", ");
        sb.append("phaseName=");
        if (this.phaseName == null) {
            sb.append(this.phaseName);
        } else {
            sb.append("'").append(this.phaseName).append("'");
        }
        sb.append(", ");
        sb.append("planPhaseSpecifier=").append(this.planPhaseSpecifier);
        sb.append(", ");
        sb.append("recurringPrice=").append(this.recurringPrice);
        sb.append(", ");
        sb.append("usagePriceOverrides=").append(this.usagePriceOverrides);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency currency;
        protected BigDecimal fixedPrice;
        protected String phaseName;
        protected PlanPhaseSpecifier planPhaseSpecifier;
        protected BigDecimal recurringPrice;
        protected List<UsagePriceOverride> usagePriceOverrides;

        public Builder() {
        }

        public Builder(Builder that) {
            this.currency = that.currency;
            this.fixedPrice = that.fixedPrice;
            this.phaseName = that.phaseName;
            this.planPhaseSpecifier = that.planPhaseSpecifier;
            this.recurringPrice = that.recurringPrice;
            this.usagePriceOverrides = that.usagePriceOverrides;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withFixedPrice(BigDecimal fixedPrice) {
            this.fixedPrice = fixedPrice;
            return (T)this;
        }

        public T withPhaseName(String phaseName) {
            this.phaseName = phaseName;
            return (T)this;
        }

        public T withPlanPhaseSpecifier(PlanPhaseSpecifier planPhaseSpecifier) {
            this.planPhaseSpecifier = planPhaseSpecifier;
            return (T)this;
        }

        public T withRecurringPrice(BigDecimal recurringPrice) {
            this.recurringPrice = recurringPrice;
            return (T)this;
        }

        public T withUsagePriceOverrides(List<UsagePriceOverride> usagePriceOverrides) {
            this.usagePriceOverrides = usagePriceOverrides;
            return (T)this;
        }

        public T source(PlanPhasePriceOverride that) {
            this.currency = that.getCurrency();
            this.fixedPrice = that.getFixedPrice();
            this.phaseName = that.getPhaseName();
            this.planPhaseSpecifier = that.getPlanPhaseSpecifier();
            this.recurringPrice = that.getRecurringPrice();
            this.usagePriceOverrides = that.getUsagePriceOverrides();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PlanPhasePriceOverrideImp build() {
            return new PlanPhasePriceOverrideImp(this.validate());
        }
    }
}

