/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Usage;

@JsonDeserialize(builder=Builder.class)
public class PlanPhaseImp
implements PlanPhase {
    protected StaticCatalog catalog;
    protected Duration duration;
    protected Fixed fixed;
    protected String name;
    protected PhaseType phaseType;
    protected String prettyName;
    protected Recurring recurring;
    protected Usage[] usages;

    public PlanPhaseImp(PlanPhaseImp that) {
        this.catalog = that.catalog;
        this.duration = that.duration;
        this.fixed = that.fixed;
        this.name = that.name;
        this.phaseType = that.phaseType;
        this.prettyName = that.prettyName;
        this.recurring = that.recurring;
        this.usages = that.usages;
    }

    protected PlanPhaseImp(Builder<?> builder) {
        this.catalog = builder.catalog;
        this.duration = builder.duration;
        this.fixed = builder.fixed;
        this.name = builder.name;
        this.phaseType = builder.phaseType;
        this.prettyName = builder.prettyName;
        this.recurring = builder.recurring;
        this.usages = builder.usages;
    }

    protected PlanPhaseImp() {
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Fixed getFixed() {
        return this.fixed;
    }

    public String getName() {
        return this.name;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public Recurring getRecurring() {
        return this.recurring;
    }

    public Usage[] getUsages() {
        return this.usages;
    }

    public boolean compliesWithLimits(String unit, double value) {
        throw new UnsupportedOperationException("compliesWithLimits(java.lang.String, double) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanPhaseImp that = (PlanPhaseImp)o;
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.fixed, that.fixed)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.phaseType, that.phaseType)) {
            return false;
        }
        if (!Objects.equals(this.prettyName, that.prettyName)) {
            return false;
        }
        if (!Objects.equals(this.recurring, that.recurring)) {
            return false;
        }
        return Arrays.deepEquals(this.usages, that.usages);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.duration);
        result = 31 * result + Objects.hashCode(this.fixed);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.phaseType);
        result = 31 * result + Objects.hashCode(this.prettyName);
        result = 31 * result + Objects.hashCode(this.recurring);
        result = 31 * result + Arrays.deepHashCode(this.usages);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("duration=").append(this.duration);
        sb.append(", ");
        sb.append("fixed=").append(this.fixed);
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("phaseType=").append(this.phaseType);
        sb.append(", ");
        sb.append("prettyName=");
        if (this.prettyName == null) {
            sb.append(this.prettyName);
        } else {
            sb.append("'").append(this.prettyName).append("'");
        }
        sb.append(", ");
        sb.append("recurring=").append(this.recurring);
        sb.append(", ");
        sb.append("usages=").append(Arrays.toString(this.usages));
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected StaticCatalog catalog;
        protected Duration duration;
        protected Fixed fixed;
        protected String name;
        protected PhaseType phaseType;
        protected String prettyName;
        protected Recurring recurring;
        protected Usage[] usages;

        public Builder() {
        }

        public Builder(Builder that) {
            this.catalog = that.catalog;
            this.duration = that.duration;
            this.fixed = that.fixed;
            this.name = that.name;
            this.phaseType = that.phaseType;
            this.prettyName = that.prettyName;
            this.recurring = that.recurring;
            this.usages = that.usages;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withDuration(Duration duration) {
            this.duration = duration;
            return (T)this;
        }

        public T withFixed(Fixed fixed) {
            this.fixed = fixed;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withPhaseType(PhaseType phaseType) {
            this.phaseType = phaseType;
            return (T)this;
        }

        public T withPrettyName(String prettyName) {
            this.prettyName = prettyName;
            return (T)this;
        }

        public T withRecurring(Recurring recurring) {
            this.recurring = recurring;
            return (T)this;
        }

        public T withUsages(Usage[] usages) {
            this.usages = usages;
            return (T)this;
        }

        public T source(PlanPhase that) {
            this.catalog = that.getCatalog();
            this.duration = that.getDuration();
            this.fixed = that.getFixed();
            this.name = that.getName();
            this.phaseType = that.getPhaseType();
            this.prettyName = that.getPrettyName();
            this.recurring = that.getRecurring();
            this.usages = that.getUsages();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PlanPhaseImp build() {
            return new PlanPhaseImp(this.validate());
        }
    }
}

