/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.Block;
import org.killbill.billing.catalog.api.BlockType;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Unit;

@JsonDeserialize(builder=Builder.class)
public class BlockImp
implements Block {
    protected Double minTopUpCredit;
    protected InternationalPrice price;
    protected Double size;
    protected BlockType type;
    protected Unit unit;

    public BlockImp(BlockImp that) {
        this.minTopUpCredit = that.minTopUpCredit;
        this.price = that.price;
        this.size = that.size;
        this.type = that.type;
        this.unit = that.unit;
    }

    protected BlockImp(Builder<?> builder) {
        this.minTopUpCredit = builder.minTopUpCredit;
        this.price = builder.price;
        this.size = builder.size;
        this.type = builder.type;
        this.unit = builder.unit;
    }

    protected BlockImp() {
    }

    public Double getMinTopUpCredit() {
        return this.minTopUpCredit;
    }

    public InternationalPrice getPrice() {
        return this.price;
    }

    public Double getSize() {
        return this.size;
    }

    public BlockType getType() {
        return this.type;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockImp that = (BlockImp)o;
        if (!Objects.equals(this.minTopUpCredit, that.minTopUpCredit)) {
            return false;
        }
        if (!Objects.equals(this.price, that.price)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.minTopUpCredit);
        result = 31 * result + Objects.hashCode(this.price);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("minTopUpCredit=").append(this.minTopUpCredit);
        sb.append(", ");
        sb.append("price=").append(this.price);
        sb.append(", ");
        sb.append("size=").append(this.size);
        sb.append(", ");
        sb.append("type=").append(this.type);
        sb.append(", ");
        sb.append("unit=").append(this.unit);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Double minTopUpCredit;
        protected InternationalPrice price;
        protected Double size;
        protected BlockType type;
        protected Unit unit;

        public Builder() {
        }

        public Builder(Builder that) {
            this.minTopUpCredit = that.minTopUpCredit;
            this.price = that.price;
            this.size = that.size;
            this.type = that.type;
            this.unit = that.unit;
        }

        public T withMinTopUpCredit(Double minTopUpCredit) {
            this.minTopUpCredit = minTopUpCredit;
            return (T)this;
        }

        public T withPrice(InternationalPrice price) {
            this.price = price;
            return (T)this;
        }

        public T withSize(Double size) {
            this.size = size;
            return (T)this;
        }

        public T withType(BlockType type) {
            this.type = type;
            return (T)this;
        }

        public T withUnit(Unit unit) {
            this.unit = unit;
            return (T)this;
        }

        public T source(Block that) throws CatalogApiException {
            this.minTopUpCredit = that.getMinTopUpCredit();
            this.price = that.getPrice();
            this.size = that.getSize();
            this.type = that.getType();
            this.unit = that.getUnit();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public BlockImp build() {
            return new BlockImp(this.validate());
        }
    }
}

