/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.catalog.api.Currency;

@JsonDeserialize(builder=Builder.class)
public class ImmutableAccountDataImp
implements ImmutableAccountData {
    protected Currency currency;
    protected String externalKey;
    protected DateTimeZone fixedOffsetTimeZone;
    protected UUID id;
    protected DateTime referenceTime;
    protected DateTimeZone timeZone;

    public ImmutableAccountDataImp(ImmutableAccountDataImp that) {
        this.currency = that.currency;
        this.externalKey = that.externalKey;
        this.fixedOffsetTimeZone = that.fixedOffsetTimeZone;
        this.id = that.id;
        this.referenceTime = that.referenceTime;
        this.timeZone = that.timeZone;
    }

    protected ImmutableAccountDataImp(Builder<?> builder) {
        this.currency = builder.currency;
        this.externalKey = builder.externalKey;
        this.fixedOffsetTimeZone = builder.fixedOffsetTimeZone;
        this.id = builder.id;
        this.referenceTime = builder.referenceTime;
        this.timeZone = builder.timeZone;
    }

    protected ImmutableAccountDataImp() {
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return this.fixedOffsetTimeZone;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getReferenceTime() {
        return this.referenceTime;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAccountDataImp that = (ImmutableAccountDataImp)o;
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        if (!Objects.equals(this.fixedOffsetTimeZone, that.fixedOffsetTimeZone)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (this.referenceTime != null ? 0 != this.referenceTime.compareTo(that.referenceTime) : that.referenceTime != null) {
            return false;
        }
        return Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.fixedOffsetTimeZone);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.referenceTime);
        result = 31 * result + Objects.hashCode(this.timeZone);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("fixedOffsetTimeZone=").append(this.fixedOffsetTimeZone);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("referenceTime=").append(this.referenceTime);
        sb.append(", ");
        sb.append("timeZone=").append(this.timeZone);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency currency;
        protected String externalKey;
        protected DateTimeZone fixedOffsetTimeZone;
        protected UUID id;
        protected DateTime referenceTime;
        protected DateTimeZone timeZone;

        public Builder() {
        }

        public Builder(Builder that) {
            this.currency = that.currency;
            this.externalKey = that.externalKey;
            this.fixedOffsetTimeZone = that.fixedOffsetTimeZone;
            this.id = that.id;
            this.referenceTime = that.referenceTime;
            this.timeZone = that.timeZone;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withFixedOffsetTimeZone(DateTimeZone fixedOffsetTimeZone) {
            this.fixedOffsetTimeZone = fixedOffsetTimeZone;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withReferenceTime(DateTime referenceTime) {
            this.referenceTime = referenceTime;
            return (T)this;
        }

        public T withTimeZone(DateTimeZone timeZone) {
            this.timeZone = timeZone;
            return (T)this;
        }

        public T source(ImmutableAccountData that) {
            this.currency = that.getCurrency();
            this.externalKey = that.getExternalKey();
            this.fixedOffsetTimeZone = that.getFixedOffsetTimeZone();
            this.id = that.getId();
            this.referenceTime = that.getReferenceTime();
            this.timeZone = that.getTimeZone();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public ImmutableAccountDataImp build() {
            return new ImmutableAccountDataImp(this.validate());
        }
    }
}

