/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.catalog.api.Currency;

@JsonDeserialize(builder=Builder.class)
public class AccountImp
implements Account {
    protected String address1;
    protected String address2;
    protected Integer billCycleDayLocal;
    protected String city;
    protected String companyName;
    protected String country;
    protected DateTime createdDate;
    protected Currency currency;
    protected String email;
    protected String externalKey;
    protected Integer firstNameLength;
    protected DateTimeZone fixedOffsetTimeZone;
    protected UUID id;
    protected Boolean isMigrated;
    protected Boolean isPaymentDelegatedToParent;
    protected String locale;
    protected String name;
    protected String notes;
    protected UUID parentAccountId;
    protected UUID paymentMethodId;
    protected String phone;
    protected String postalCode;
    protected DateTime referenceTime;
    protected String stateOrProvince;
    protected DateTimeZone timeZone;
    protected DateTime updatedDate;

    public AccountImp(AccountImp that) {
        this.address1 = that.address1;
        this.address2 = that.address2;
        this.billCycleDayLocal = that.billCycleDayLocal;
        this.city = that.city;
        this.companyName = that.companyName;
        this.country = that.country;
        this.createdDate = that.createdDate;
        this.currency = that.currency;
        this.email = that.email;
        this.externalKey = that.externalKey;
        this.firstNameLength = that.firstNameLength;
        this.fixedOffsetTimeZone = that.fixedOffsetTimeZone;
        this.id = that.id;
        this.isMigrated = that.isMigrated;
        this.isPaymentDelegatedToParent = that.isPaymentDelegatedToParent;
        this.locale = that.locale;
        this.name = that.name;
        this.notes = that.notes;
        this.parentAccountId = that.parentAccountId;
        this.paymentMethodId = that.paymentMethodId;
        this.phone = that.phone;
        this.postalCode = that.postalCode;
        this.referenceTime = that.referenceTime;
        this.stateOrProvince = that.stateOrProvince;
        this.timeZone = that.timeZone;
        this.updatedDate = that.updatedDate;
    }

    protected AccountImp(Builder<?> builder) {
        this.address1 = builder.address1;
        this.address2 = builder.address2;
        this.billCycleDayLocal = builder.billCycleDayLocal;
        this.city = builder.city;
        this.companyName = builder.companyName;
        this.country = builder.country;
        this.createdDate = builder.createdDate;
        this.currency = builder.currency;
        this.email = builder.email;
        this.externalKey = builder.externalKey;
        this.firstNameLength = builder.firstNameLength;
        this.fixedOffsetTimeZone = builder.fixedOffsetTimeZone;
        this.id = builder.id;
        this.isMigrated = builder.isMigrated;
        this.isPaymentDelegatedToParent = builder.isPaymentDelegatedToParent;
        this.locale = builder.locale;
        this.name = builder.name;
        this.notes = builder.notes;
        this.parentAccountId = builder.parentAccountId;
        this.paymentMethodId = builder.paymentMethodId;
        this.phone = builder.phone;
        this.postalCode = builder.postalCode;
        this.referenceTime = builder.referenceTime;
        this.stateOrProvince = builder.stateOrProvince;
        this.timeZone = builder.timeZone;
        this.updatedDate = builder.updatedDate;
    }

    protected AccountImp() {
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public String getCity() {
        return this.city;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCountry() {
        return this.country;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getEmail() {
        return this.email;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return this.fixedOffsetTimeZone;
    }

    public UUID getId() {
        return this.id;
    }

    @JsonGetter(value="isMigrated")
    public Boolean isMigrated() {
        return this.isMigrated;
    }

    @JsonGetter(value="isPaymentDelegatedToParent")
    public Boolean isPaymentDelegatedToParent() {
        return this.isPaymentDelegatedToParent;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public DateTime getReferenceTime() {
        return this.referenceTime;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public MutableAccountData toMutableAccountData() {
        throw new UnsupportedOperationException("toMutableAccountData() must be implemented.");
    }

    public Account mergeWithDelegate(Account delegate) {
        throw new UnsupportedOperationException("mergeWithDelegate(org.killbill.billing.account.api.Account) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountImp that = (AccountImp)o;
        if (!Objects.equals(this.address1, that.address1)) {
            return false;
        }
        if (!Objects.equals(this.address2, that.address2)) {
            return false;
        }
        if (!Objects.equals(this.billCycleDayLocal, that.billCycleDayLocal)) {
            return false;
        }
        if (!Objects.equals(this.city, that.city)) {
            return false;
        }
        if (!Objects.equals(this.companyName, that.companyName)) {
            return false;
        }
        if (!Objects.equals(this.country, that.country)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (!Objects.equals(this.email, that.email)) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        if (!Objects.equals(this.firstNameLength, that.firstNameLength)) {
            return false;
        }
        if (!Objects.equals(this.fixedOffsetTimeZone, that.fixedOffsetTimeZone)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.isMigrated, that.isMigrated)) {
            return false;
        }
        if (!Objects.equals(this.isPaymentDelegatedToParent, that.isPaymentDelegatedToParent)) {
            return false;
        }
        if (!Objects.equals(this.locale, that.locale)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.notes, that.notes)) {
            return false;
        }
        if (!Objects.equals(this.parentAccountId, that.parentAccountId)) {
            return false;
        }
        if (!Objects.equals(this.paymentMethodId, that.paymentMethodId)) {
            return false;
        }
        if (!Objects.equals(this.phone, that.phone)) {
            return false;
        }
        if (!Objects.equals(this.postalCode, that.postalCode)) {
            return false;
        }
        if (this.referenceTime != null ? 0 != this.referenceTime.compareTo(that.referenceTime) : that.referenceTime != null) {
            return false;
        }
        if (!Objects.equals(this.stateOrProvince, that.stateOrProvince)) {
            return false;
        }
        if (!Objects.equals(this.timeZone, that.timeZone)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.address1);
        result = 31 * result + Objects.hashCode(this.address2);
        result = 31 * result + Objects.hashCode(this.billCycleDayLocal);
        result = 31 * result + Objects.hashCode(this.city);
        result = 31 * result + Objects.hashCode(this.companyName);
        result = 31 * result + Objects.hashCode(this.country);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.email);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.firstNameLength);
        result = 31 * result + Objects.hashCode(this.fixedOffsetTimeZone);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.isMigrated);
        result = 31 * result + Objects.hashCode(this.isPaymentDelegatedToParent);
        result = 31 * result + Objects.hashCode(this.locale);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.notes);
        result = 31 * result + Objects.hashCode(this.parentAccountId);
        result = 31 * result + Objects.hashCode(this.paymentMethodId);
        result = 31 * result + Objects.hashCode(this.phone);
        result = 31 * result + Objects.hashCode(this.postalCode);
        result = 31 * result + Objects.hashCode(this.referenceTime);
        result = 31 * result + Objects.hashCode(this.stateOrProvince);
        result = 31 * result + Objects.hashCode(this.timeZone);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("address1=");
        if (this.address1 == null) {
            sb.append(this.address1);
        } else {
            sb.append("'").append(this.address1).append("'");
        }
        sb.append(", ");
        sb.append("address2=");
        if (this.address2 == null) {
            sb.append(this.address2);
        } else {
            sb.append("'").append(this.address2).append("'");
        }
        sb.append(", ");
        sb.append("billCycleDayLocal=").append(this.billCycleDayLocal);
        sb.append(", ");
        sb.append("city=");
        if (this.city == null) {
            sb.append(this.city);
        } else {
            sb.append("'").append(this.city).append("'");
        }
        sb.append(", ");
        sb.append("companyName=");
        if (this.companyName == null) {
            sb.append(this.companyName);
        } else {
            sb.append("'").append(this.companyName).append("'");
        }
        sb.append(", ");
        sb.append("country=");
        if (this.country == null) {
            sb.append(this.country);
        } else {
            sb.append("'").append(this.country).append("'");
        }
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("email=");
        if (this.email == null) {
            sb.append(this.email);
        } else {
            sb.append("'").append(this.email).append("'");
        }
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("firstNameLength=").append(this.firstNameLength);
        sb.append(", ");
        sb.append("fixedOffsetTimeZone=").append(this.fixedOffsetTimeZone);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("isMigrated=").append(this.isMigrated);
        sb.append(", ");
        sb.append("isPaymentDelegatedToParent=").append(this.isPaymentDelegatedToParent);
        sb.append(", ");
        sb.append("locale=");
        if (this.locale == null) {
            sb.append(this.locale);
        } else {
            sb.append("'").append(this.locale).append("'");
        }
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("notes=");
        if (this.notes == null) {
            sb.append(this.notes);
        } else {
            sb.append("'").append(this.notes).append("'");
        }
        sb.append(", ");
        sb.append("parentAccountId=").append(this.parentAccountId);
        sb.append(", ");
        sb.append("paymentMethodId=").append(this.paymentMethodId);
        sb.append(", ");
        sb.append("phone=");
        if (this.phone == null) {
            sb.append(this.phone);
        } else {
            sb.append("'").append(this.phone).append("'");
        }
        sb.append(", ");
        sb.append("postalCode=");
        if (this.postalCode == null) {
            sb.append(this.postalCode);
        } else {
            sb.append("'").append(this.postalCode).append("'");
        }
        sb.append(", ");
        sb.append("referenceTime=").append(this.referenceTime);
        sb.append(", ");
        sb.append("stateOrProvince=");
        if (this.stateOrProvince == null) {
            sb.append(this.stateOrProvince);
        } else {
            sb.append("'").append(this.stateOrProvince).append("'");
        }
        sb.append(", ");
        sb.append("timeZone=").append(this.timeZone);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String address1;
        protected String address2;
        protected Integer billCycleDayLocal;
        protected String city;
        protected String companyName;
        protected String country;
        protected DateTime createdDate;
        protected Currency currency;
        protected String email;
        protected String externalKey;
        protected Integer firstNameLength;
        protected DateTimeZone fixedOffsetTimeZone;
        protected UUID id;
        protected Boolean isMigrated;
        protected Boolean isPaymentDelegatedToParent;
        protected String locale;
        protected String name;
        protected String notes;
        protected UUID parentAccountId;
        protected UUID paymentMethodId;
        protected String phone;
        protected String postalCode;
        protected DateTime referenceTime;
        protected String stateOrProvince;
        protected DateTimeZone timeZone;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.address1 = that.address1;
            this.address2 = that.address2;
            this.billCycleDayLocal = that.billCycleDayLocal;
            this.city = that.city;
            this.companyName = that.companyName;
            this.country = that.country;
            this.createdDate = that.createdDate;
            this.currency = that.currency;
            this.email = that.email;
            this.externalKey = that.externalKey;
            this.firstNameLength = that.firstNameLength;
            this.fixedOffsetTimeZone = that.fixedOffsetTimeZone;
            this.id = that.id;
            this.isMigrated = that.isMigrated;
            this.isPaymentDelegatedToParent = that.isPaymentDelegatedToParent;
            this.locale = that.locale;
            this.name = that.name;
            this.notes = that.notes;
            this.parentAccountId = that.parentAccountId;
            this.paymentMethodId = that.paymentMethodId;
            this.phone = that.phone;
            this.postalCode = that.postalCode;
            this.referenceTime = that.referenceTime;
            this.stateOrProvince = that.stateOrProvince;
            this.timeZone = that.timeZone;
            this.updatedDate = that.updatedDate;
        }

        public T withAddress1(String address1) {
            this.address1 = address1;
            return (T)this;
        }

        public T withAddress2(String address2) {
            this.address2 = address2;
            return (T)this;
        }

        public T withBillCycleDayLocal(Integer billCycleDayLocal) {
            this.billCycleDayLocal = billCycleDayLocal;
            return (T)this;
        }

        public T withCity(String city) {
            this.city = city;
            return (T)this;
        }

        public T withCompanyName(String companyName) {
            this.companyName = companyName;
            return (T)this;
        }

        public T withCountry(String country) {
            this.country = country;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withEmail(String email) {
            this.email = email;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withFirstNameLength(Integer firstNameLength) {
            this.firstNameLength = firstNameLength;
            return (T)this;
        }

        public T withFixedOffsetTimeZone(DateTimeZone fixedOffsetTimeZone) {
            this.fixedOffsetTimeZone = fixedOffsetTimeZone;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withIsMigrated(Boolean isMigrated) {
            this.isMigrated = isMigrated;
            return (T)this;
        }

        public T withIsPaymentDelegatedToParent(Boolean isPaymentDelegatedToParent) {
            this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
            return (T)this;
        }

        public T withLocale(String locale) {
            this.locale = locale;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withNotes(String notes) {
            this.notes = notes;
            return (T)this;
        }

        public T withParentAccountId(UUID parentAccountId) {
            this.parentAccountId = parentAccountId;
            return (T)this;
        }

        public T withPaymentMethodId(UUID paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return (T)this;
        }

        public T withPhone(String phone) {
            this.phone = phone;
            return (T)this;
        }

        public T withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return (T)this;
        }

        public T withReferenceTime(DateTime referenceTime) {
            this.referenceTime = referenceTime;
            return (T)this;
        }

        public T withStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return (T)this;
        }

        public T withTimeZone(DateTimeZone timeZone) {
            this.timeZone = timeZone;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(Account that) {
            this.address1 = that.getAddress1();
            this.address2 = that.getAddress2();
            this.billCycleDayLocal = that.getBillCycleDayLocal();
            this.city = that.getCity();
            this.companyName = that.getCompanyName();
            this.country = that.getCountry();
            this.createdDate = that.getCreatedDate();
            this.currency = that.getCurrency();
            this.email = that.getEmail();
            this.externalKey = that.getExternalKey();
            this.firstNameLength = that.getFirstNameLength();
            this.fixedOffsetTimeZone = that.getFixedOffsetTimeZone();
            this.id = that.getId();
            this.isMigrated = that.isMigrated();
            this.isPaymentDelegatedToParent = that.isPaymentDelegatedToParent();
            this.locale = that.getLocale();
            this.name = that.getName();
            this.notes = that.getNotes();
            this.parentAccountId = that.getParentAccountId();
            this.paymentMethodId = that.getPaymentMethodId();
            this.phone = that.getPhone();
            this.postalCode = that.getPostalCode();
            this.referenceTime = that.getReferenceTime();
            this.stateOrProvince = that.getStateOrProvince();
            this.timeZone = that.getTimeZone();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public AccountImp build() {
            return new AccountImp(this.validate());
        }
    }
}

