/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.AccountEmail;

@JsonDeserialize(builder=Builder.class)
public class AccountEmailImp
implements AccountEmail {
    protected UUID accountId;
    protected DateTime createdDate;
    protected String email;
    protected UUID id;
    protected DateTime updatedDate;

    public AccountEmailImp(AccountEmailImp that) {
        this.accountId = that.accountId;
        this.createdDate = that.createdDate;
        this.email = that.email;
        this.id = that.id;
        this.updatedDate = that.updatedDate;
    }

    protected AccountEmailImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.createdDate = builder.createdDate;
        this.email = builder.email;
        this.id = builder.id;
        this.updatedDate = builder.updatedDate;
    }

    protected AccountEmailImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public String getEmail() {
        return this.email;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountEmailImp that = (AccountEmailImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.email, that.email)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.email);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("email=");
        if (this.email == null) {
            sb.append(this.email);
        } else {
            sb.append("'").append(this.email).append("'");
        }
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected DateTime createdDate;
        protected String email;
        protected UUID id;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.createdDate = that.createdDate;
            this.email = that.email;
            this.id = that.id;
            this.updatedDate = that.updatedDate;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withEmail(String email) {
            this.email = email;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(AccountEmail that) {
            this.accountId = that.getAccountId();
            this.createdDate = that.getCreatedDate();
            this.email = that.getEmail();
            this.id = that.getId();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public AccountEmailImp build() {
            return new AccountEmailImp(this.validate());
        }
    }
}

