/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jooq.Asterisk;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.Insert;
import org.jooq.QualifiedAsterisk;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.Update;
import org.jooq.conf.ExecuteWithoutWhere;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultUnwrapperProvider;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.BatchedPreparedStatement;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.sqlite.SQLiteDSL;

abstract class AbstractDMLQuery<R extends Record>
extends AbstractRowCountQuery {
    private static final long serialVersionUID = -7438014075226919192L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private static final Set<SQLDialect> NO_SUPPORT_INSERT_ALIASED_TABLE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NATIVE_SUPPORT_INSERT_RETURNING = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NATIVE_SUPPORT_UPDATE_RETURNING = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NATIVE_SUPPORT_DELETE_RETURNING = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.POSTGRES);
    private final WithImpl with;
    private final Table<R> table;
    final SelectFieldList<SelectFieldOrAsterisk> returning;
    final List<Field<?>> returningResolvedAsterisks;
    Result<Record> returnedResult;
    Result<R> returned;

    AbstractDMLQuery(Configuration configuration, WithImpl with, Table<R> table) {
        super(configuration);
        this.with = with;
        this.table = table;
        this.returning = new SelectFieldList();
        this.returningResolvedAsterisks = new ArrayList();
    }

    public final void setReturning() {
        this.setReturning(this.table.fields());
    }

    public final void setReturning(Identity<R, ?> identity) {
        if (identity != null) {
            this.setReturning(identity.getField());
        }
    }

    public final void setReturning(SelectFieldOrAsterisk ... fields) {
        this.setReturning(Arrays.asList(fields));
    }

    public final void setReturning(Collection<? extends SelectFieldOrAsterisk> fields) {
        this.returning.clear();
        this.returning.addAll(fields.isEmpty() ? Arrays.asList(this.table.fields()) : fields);
        this.returningResolvedAsterisks.clear();
        for (SelectFieldOrAsterisk f : this.returning) {
            if (f instanceof Field) {
                this.returningResolvedAsterisks.add((Field)f);
                continue;
            }
            if (f instanceof QualifiedAsterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(((QualifiedAsterisk)f).qualifier().fields()));
                continue;
            }
            if (f instanceof Asterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(this.table.fields()));
                continue;
            }
            throw new AssertionError((Object)("Type not supported: " + f));
        }
    }

    public final R getReturnedRecord() {
        if (this.getReturnedRecords().isEmpty()) {
            return null;
        }
        return (R)((Record)this.getReturnedRecords().get(0));
    }

    public final Result<R> getReturnedRecords() {
        if (this.returned == null) {
            if (this.table.fields().length > 0) {
                this.warnOnAPIMisuse();
                this.returned = this.getResult().into(this.table);
            } else {
                this.returned = this.getResult();
            }
        }
        return this.returned;
    }

    private final void warnOnAPIMisuse() {
        for (Field<?> field : this.getResult().fields()) {
            if (this.table.field(field) != null) continue;
            log.warn((Object)"API misuse", "Column " + field + " has been requested through the returning() clause, which is not present in table " + this.table + ". Use StoreQuery.getResult() or the returningResult() clause instead.");
        }
    }

    final Table<R> table() {
        return this.table;
    }

    final Table<?> table(Context<?> ctx) {
        if (NO_SUPPORT_INSERT_ALIASED_TABLE.contains((Object)ctx.dialect()) && this instanceof Insert) {
            return StringUtils.defaultIfNull(Tools.aliased(this.table()), this.table());
        }
        return this.table();
    }

    public final Result<?> getResult() {
        if (this.returnedResult == null) {
            this.returnedResult = new ResultImpl<Record>(this.configuration(), this.returningResolvedAsterisks);
        }
        return this.returnedResult;
    }

    @Override
    public final void accept(Context<?> ctx) {
        WithImpl w = this.with;
        ctx.data((Object)Tools.DataKey.DATA_DML_TARGET_TABLE, this.table);
        if (w != null) {
            ctx.visit(w);
        }
        boolean previousDeclareFields = ctx.declareFields();
        this.accept0(ctx);
        ctx.data().remove((Object)Tools.DataKey.DATA_DML_TARGET_TABLE);
    }

    abstract void accept0(Context<?> var1);

    void executeWithoutWhere(String message, ExecuteWithoutWhere executeWithoutWhere) {
        switch (executeWithoutWhere) {
            case IGNORE: {
                break;
            }
            case LOG_DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_WARN: {
                log.warn((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case THROW: {
                throw new DataAccessException("A statement is executed without WHERE clause");
            }
        }
    }

    final void toSQLReturning(Context<?> ctx) {
        if (!this.returning.isEmpty() && this.nativeSupportReturning(ctx)) {
            boolean unqualify;
            boolean declareFields = ctx.declareFields();
            boolean qualify = ctx.qualify();
            boolean bl = unqualify = ctx.family() == SQLDialect.MARIADB;
            if (unqualify) {
                ctx.qualify(false);
            }
            ctx.formatSeparator().visit(Keywords.K_RETURNING).sql(' ').declareFields(true).visit(ctx.family() == SQLDialect.FIREBIRD || ctx.family() == SQLDialect.MARIADB ? new SelectFieldList((Iterable<Field<?>>)this.returningResolvedAsterisks) : this.returning).declareFields(declareFields);
            if (unqualify) {
                ctx.qualify(qualify);
            }
        }
    }

    private final boolean nativeSupportReturning(Scope ctx) {
        return this instanceof Insert && NATIVE_SUPPORT_INSERT_RETURNING.contains((Object)ctx.dialect()) || this instanceof Update && NATIVE_SUPPORT_UPDATE_RETURNING.contains((Object)ctx.dialect()) || this instanceof Delete && NATIVE_SUPPORT_DELETE_RETURNING.contains((Object)ctx.dialect());
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        this.prepare0(ctx);
        Tools.setFetchSize(ctx, 0);
    }

    private final void prepare0(ExecuteContext ctx) throws SQLException {
        Connection connection = ctx.connection();
        if (this.returning.isEmpty()) {
            super.prepare(ctx);
        } else if (this.nativeSupportReturning(ctx)) {
            super.prepare(ctx);
        } else {
            switch (ctx.family()) {
                case SQLITE: 
                case CUBRID: {
                    super.prepare(ctx);
                    break;
                }
                case DERBY: 
                case H2: 
                case MARIADB: 
                case MYSQL: {
                    if (ctx.statement() != null) break;
                    ctx.statement(connection.prepareStatement(ctx.sql(), 1));
                    break;
                }
                default: {
                    if (ctx.statement() != null) break;
                    ArrayList<String> names = new ArrayList<String>(this.returningResolvedAsterisks.size());
                    RenderNameCase style = SettingsTools.getRenderNameCase(this.configuration().settings());
                    if (style == RenderNameCase.UPPER) {
                        for (Field<?> f : Tools.flattenCollection(this.returningResolvedAsterisks, false)) {
                            names.add(f.getName().toUpperCase(SettingsTools.renderLocale(this.configuration().settings())));
                        }
                    } else if (style == RenderNameCase.LOWER) {
                        for (Field<?> f : Tools.flattenCollection(this.returningResolvedAsterisks, false)) {
                            names.add(f.getName().toLowerCase(SettingsTools.renderLocale(this.configuration().settings())));
                        }
                    } else {
                        for (Field<?> f : Tools.flattenCollection(this.returningResolvedAsterisks, false)) {
                            names.add(f.getName());
                        }
                    }
                    ctx.statement(connection.prepareStatement(ctx.sql(), names.toArray(Tools.EMPTY_STRING)));
                }
            }
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        ResultSet rs;
        this.returned = null;
        this.returnedResult = null;
        if (this.returning.isEmpty()) {
            return super.execute(ctx, listener);
        }
        int result = 1;
        switch (ctx.family()) {
            case SQLITE: {
                listener.executeStart(ctx);
                result = this.executeImmediate(ctx.statement()).executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                DSLContext create = ctx.dsl();
                this.returnedResult = create.select(this.returning).from((TableLike<?>)this.table).where(SQLiteDSL.rowid().equal((Long)SQLiteDSL.rowid().getDataType().convert((Object)create.lastID()))).fetch();
                this.returnedResult.attach(((DefaultExecuteContext)ctx).originalConfiguration());
                return result;
            }
            case CUBRID: {
                listener.executeStart(ctx);
                result = this.executeImmediate(ctx.statement()).executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), ctx.dsl().lastID());
                return result;
            }
            case DERBY: 
            case H2: 
            case MYSQL: {
                return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
            }
            case MARIADB: {
                if (!this.nativeSupportReturning(ctx)) {
                    return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
                }
                rs = this.executeReturningQuery(ctx, listener);
                break;
            }
            case FIREBIRD: 
            case POSTGRES: {
                rs = this.executeReturningQuery(ctx, listener);
                break;
            }
            default: {
                rs = this.executeReturningGeneratedKeys(ctx, listener);
            }
        }
        DefaultExecuteContext ctx2 = new DefaultExecuteContext(((DefaultExecuteContext)ctx).originalConfiguration());
        ExecuteListener listener2 = ExecuteListeners.getAndStart(ctx2);
        ctx2.resultSet(rs);
        this.returnedResult = new CursorImpl(ctx2, listener2, this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD), null, false, true).fetch();
        if (!this.returnedResult.isEmpty() || ctx.family() != SQLDialect.HSQLDB) {
            result = this.returnedResult.size();
            ctx.rows(result);
        }
        return result;
    }

    private final PreparedStatement executeImmediate(PreparedStatement s2) throws SQLException {
        if (DefaultUnwrapperProvider.DefaultUnwrapper.isWrapperFor(s2, BatchedPreparedStatement.class)) {
            s2.unwrap(BatchedPreparedStatement.class).setExecuteImmediate(true);
        }
        return s2;
    }

    private final ResultSet executeReturningGeneratedKeys(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        listener.executeEnd(ctx);
        return ctx.statement().getGeneratedKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int executeReturningGeneratedKeysFetchAdditionalRows(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        listener.executeEnd(ctx);
        ResultSet rs = ctx.statement().getGeneratedKeys();
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
            }
            this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), list.toArray());
            int n = result;
            return n;
        }
        finally {
            JDBCUtils.safeClose(rs);
        }
    }

    private final ResultSet executeReturningQuery(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        ResultSet rs = ctx.statement().executeQuery();
        listener.executeEnd(ctx);
        return rs;
    }

    private final void selectReturning(Configuration originalConfiguration, Configuration derivedConfiguration, Object ... values) {
        Field<?> returnIdentity;
        if (values != null && values.length > 0 && (returnIdentity = this.returnedIdentity()) != null) {
            Object[] ids = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                ids[i] = returnIdentity.getDataType().convert(values[i]);
            }
            if (this.returningResolvedAsterisks.size() == 1 && new Fields(this.returningResolvedAsterisks).field(returnIdentity) != null) {
                AbstractRow fields = Tools.row0(this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD));
                for (final Object id : ids) {
                    this.getResult().add(Tools.newRecord(true, AbstractRecord.class, fields, originalConfiguration).operate(new RecordOperation<AbstractRecord, RuntimeException>(){

                        @Override
                        public AbstractRecord operate(AbstractRecord record) throws RuntimeException {
                            record.values[0] = id;
                            record.originals[0] = id;
                            return record;
                        }
                    }));
                }
            } else {
                this.returnedResult = derivedConfiguration.dsl().select(this.returning).from((TableLike<?>)this.table).where(this.table.field(returnIdentity).in(ids)).fetch();
                this.returnedResult.attach(originalConfiguration);
            }
        }
    }

    private final Field<?> returnedIdentity() {
        if (this.table.getIdentity() != null) {
            return this.table.getIdentity().getField();
        }
        for (Field<?> field : this.returningResolvedAsterisks) {
            if (!field.getDataType().identity()) continue;
            return field;
        }
        return null;
    }
}

