/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;
import org.jooq.Converter;
import org.jooq.impl.AbstractConverter;
import org.jooq.impl.IdentityConverter;
import org.jooq.tools.Convert;

public class Converters<T, U>
extends AbstractConverter<T, U> {
    private static final long serialVersionUID = -4307758248063822630L;
    final Converter[] chain;

    @NotNull
    public static <T> Converter<T, T> identity(Class<T> type) {
        return new IdentityConverter<T>(type);
    }

    @Deprecated
    @NotNull
    public static <T, U> Converter<T, U> of() {
        return new Converters<T, U>(new Converter[0]);
    }

    @Deprecated
    @NotNull
    public static <T, U> Converter<T, U> of(Converter<T, U> converter) {
        return new Converters<T, U>(converter);
    }

    @NotNull
    public static <T, X1, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, U> c2) {
        return new Converters<T, U>(c1, c2);
    }

    @NotNull
    public static <T, X1, X2, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, U> c3) {
        return new Converters<T, U>(c1, c2, c3);
    }

    @NotNull
    public static <T, X1, X2, X3, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, ? extends X3> c3, Converter<? super X3, U> c4) {
        return new Converters<T, U>(c1, c2, c3, c4);
    }

    public static <T, U> Converter<U, T> inverse(final Converter<T, U> converter) {
        if (converter instanceof IdentityConverter) {
            return converter;
        }
        return new AbstractConverter<U, T>(converter.toType(), converter.fromType()){
            private static final long serialVersionUID = -4307758248063822630L;

            @Override
            public T from(U u) {
                return converter.to(u);
            }

            @Override
            public U to(T t2) {
                return converter.from(t2);
            }

            @Override
            public String toString() {
                return "InverseConverter [ " + this.fromType().getName() + " -> " + this.toType().getName() + " ]";
            }
        };
    }

    public static <T, U> Converter<T[], U[]> forArrays(final Converter<T, U> converter) {
        return new AbstractConverter<T[], U[]>(Array.newInstance(converter.fromType(), 0).getClass(), Array.newInstance(converter.toType(), 0).getClass()){
            private static final long serialVersionUID = -4307758248063822630L;
            private final Converter<U, T> inverse;
            {
                super(fromType, toType);
                this.inverse = Converters.inverse(converter);
            }

            @Override
            public U[] from(T[] t2) {
                return Convert.convertArray((Object[])t2, converter);
            }

            @Override
            public T[] to(U[] u) {
                return Convert.convertArray((Object[])u, this.inverse);
            }
        };
    }

    Converters(Converter ... chain) {
        super(chain[0].fromType(), chain[chain.length - 1].toType());
        this.chain = chain;
    }

    @Override
    public final U from(T t2) {
        Object result = t2;
        for (int i = 0; i < this.chain.length; ++i) {
            result = this.chain[i].from(result);
        }
        return (U)result;
    }

    @Override
    public final T to(U u) {
        Object result = u;
        for (int i = this.chain.length - 1; i >= 0; --i) {
            result = this.chain[i].to(result);
        }
        return (T)result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = " -> ";
        sb.append("Converters [ ");
        sb.append(this.fromType().getName());
        for (Converter converter : this.chain) {
            sb.append(separator);
            sb.append(converter.toType().getName());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

