/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.funzy.Throwing;
import org.jooby.servlet.ServletContainer;
import org.jooby.spi.Server;

public class ServerInitializer
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        String appClass = ctx.getInitParameter("application.class");
        Objects.requireNonNull(appClass, "Context param NOT found: application.class");
        Jooby.run(Throwing.throwingSupplier(() -> {
            Jooby app = (Jooby)ctx.getClassLoader().loadClass(appClass).newInstance();
            ctx.setAttribute(Jooby.class.getName(), (Object)app);
            return app;
        }), "application.path=" + ctx.getContextPath(), "server.module=" + ServletModule.class.getName());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        Jooby app = (Jooby)ctx.getAttribute(Jooby.class.getName());
        if (app != null) {
            app.stop();
        }
    }

    public static class ServletModule
    implements Jooby.Module {
        @Override
        public void configure(Env env, Config config, Binder binder) {
            binder.bind(Server.class).toInstance(ServletContainer.NOOP);
        }
    }
}

