/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.inject.TypeLiteral;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.inject.Inject;
import org.jooby.Parser;

public class ZonedDateTimeParser
implements Parser {
    private DateTimeFormatter formatter;

    @Inject
    public ZonedDateTimeParser(DateTimeFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter, "A date time formatter is required.");
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        if (type.getRawType() == ZonedDateTime.class) {
            return ctx.param(values -> ZonedDateTimeParser.parse(this.formatter, (String)NOT_EMPTY.apply(values.get(0)))).body(body -> ZonedDateTimeParser.parse(this.formatter, (String)NOT_EMPTY.apply(body.text())));
        }
        return ctx.next();
    }

    public String toString() {
        return "ZonedDateTime";
    }

    private static ZonedDateTime parse(DateTimeFormatter formatter, String value) {
        return ZonedDateTime.parse(value, formatter);
    }
}

