/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.handlers;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.RouteImpl;

public class HeadHandler
implements Route.Filter {
    private Set<Route.Definition> routes;

    @Inject
    public HeadHandler(Set<Route.Definition> routes) {
        this.routes = Objects.requireNonNull(routes, "Routes are required.");
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        String path = req.path();
        for (Route.Definition router : this.routes) {
            Optional<Route> ifRoute;
            if (router.glob() || !(ifRoute = router.matches("GET", path, MediaType.all, MediaType.ALL)).isPresent()) continue;
            rsp.length(0L);
            ((RouteImpl)ifRoute.get()).handle(req, rsp, chain);
            return;
        }
        chain.next(req, rsp);
    }
}

