/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jooby.Cookie;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;

public class FlashScopeHandler
implements Route.Filter {
    private Cookie.Definition template;
    private String cname;
    private Function<String, Map<String, String>> decoder;
    private Function<Map<String, String>, String> encoder;

    public FlashScopeHandler(Cookie.Definition cookie, Function<String, Map<String, String>> decoder, Function<Map<String, String>, String> encoder) {
        this.template = cookie;
        this.cname = cookie.name().get();
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        Optional<String> value = req.cookie(this.cname).toOptional();
        Map source = value.map(this.decoder::apply).orElseGet(HashMap::new);
        FlashMap flashScope = new FlashMap(source);
        req.set("flash", (Object)flashScope);
        rsp.after(this.finalizeFlash(source, flashScope));
        chain.next(req, rsp);
    }

    private Route.After finalizeFlash(Map<String, String> initialScope, FlashMap scope) {
        return (req, rsp, result) -> {
            if (scope.keep) {
                if (scope.size() > 0) {
                    rsp.cookie(new Cookie.Definition(this.template).value(this.encoder.apply(scope)));
                } else if (initialScope.size() > 0) {
                    rsp.cookie(new Cookie.Definition(this.template).maxAge(0));
                }
            } else if (scope.equals(initialScope)) {
                if (scope.size() > 0) {
                    rsp.cookie(new Cookie.Definition(this.template).maxAge(0));
                }
            } else if (scope.size() == 0) {
                rsp.cookie(new Cookie.Definition(this.template).maxAge(0));
            } else {
                rsp.cookie(new Cookie.Definition(this.template).value(this.encoder.apply(scope)));
            }
            return result;
        };
    }

    public static class FlashMap
    extends HashMap<String, String>
    implements Request.Flash {
        private boolean keep;

        public FlashMap(Map<String, String> source) {
            super(source);
        }

        @Override
        public void keep() {
            this.keep = true;
        }
    }
}

