/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Upload;
import org.jooby.internal.MutantImpl;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.spi.NativeUpload;

public class UploadImpl
implements Upload {
    private Injector injector;
    private NativeUpload upload;

    public UploadImpl(Injector injector, NativeUpload upload) {
        this.injector = Objects.requireNonNull(injector, "An injector is required.");
        this.upload = Objects.requireNonNull(upload, "An upload is required.");
    }

    @Override
    public void close() throws IOException {
        this.upload.close();
    }

    @Override
    public String name() {
        return this.upload.name();
    }

    @Override
    public MediaType type() {
        return this.header("Content-Type").toOptional(MediaType.class).orElseGet(() -> MediaType.byPath(this.name()).orElse(MediaType.octetstream));
    }

    @Override
    public Mutant header(String name) {
        return new MutantImpl(this.injector.getInstance(ParserExecutor.class), new StrParamReferenceImpl("header", name, this.upload.headers(name)));
    }

    @Override
    public File file() throws IOException {
        return this.upload.file();
    }

    public String toString() {
        return this.name();
    }
}

