/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jooby.Asset;
import org.jooby.MediaType;

public class URLAsset
implements Asset {
    private URL url;
    private MediaType mediaType;
    private long lastModified = -1L;
    private long length = -1L;
    private Supplier stream;
    private String path;
    private boolean exists;

    public URLAsset(URL url, String path, MediaType mediaType) throws Exception {
        this.url = Objects.requireNonNull(url, "An url is required.");
        this.path = Objects.requireNonNull(path, "Path is required.");
        this.mediaType = Objects.requireNonNull(mediaType, "A mediaType is required.");
        this.stream = URLAsset.attr(url, (len, lstMod) -> {
            this.length = URLAsset.len(len);
            this.lastModified = URLAsset.lmod(lstMod);
        });
        this.exists = this.stream != null;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public URL resource() {
        return this.url;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public InputStream stream() throws Exception {
        return this.stream.get();
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public MediaType type() {
        return this.mediaType;
    }

    public String toString() {
        return this.path() + "(" + this.type() + ")";
    }

    private static Supplier attr(URL resource, BiConsumer<Long, Long> attrs) throws Exception {
        if ("file".equals(resource.getProtocol())) {
            File file = new File(resource.toURI());
            if (file.exists() && file.isFile()) {
                attrs.accept(file.length(), file.lastModified());
                return () -> new FileInputStream(file);
            }
            return null;
        }
        URLConnection cnn = resource.openConnection();
        cnn.setUseCaches(false);
        attrs.accept(cnn.getContentLengthLong(), cnn.getLastModified());
        try {
            Closeables.closeQuietly(cnn.getInputStream());
        }
        catch (NullPointerException ex) {
            return null;
        }
        return () -> resource.openStream();
    }

    private static long len(long value) {
        return value < 0L ? -1L : value;
    }

    private static long lmod(long value) {
        return value > 0L ? value : -1L;
    }

    public boolean exists() {
        return this.exists;
    }

    static interface Supplier {
        public InputStream get() throws IOException;
    }
}

