/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.primitives.Primitives;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.TypeConverter;
import org.jooby.internal.parser.StaticMethodParser;

class StaticMethodTypeConverter<T>
extends AbstractMatcher<TypeLiteral<T>>
implements TypeConverter {
    private StaticMethodParser converter;

    public StaticMethodTypeConverter(String name) {
        this.converter = new StaticMethodParser(name);
    }

    @Override
    public Object convert(String value, TypeLiteral<?> type) {
        try {
            return this.converter.parse(type, value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't convert: " + value + " to " + type, ex);
        }
    }

    @Override
    public boolean matches(TypeLiteral<T> type) {
        Class<T> rawType = type.getRawType();
        if (rawType == Class.class) {
            return false;
        }
        if (Primitives.isWrapperType(rawType)) {
            return false;
        }
        return !Enum.class.isAssignableFrom(rawType) && this.converter.matches(type);
    }

    public String toString() {
        return this.converter.toString();
    }
}

