/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jooby.Cookie;
import org.jooby.Deferred;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Renderer;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Try;
import org.jooby.internal.DeferredExecution;
import org.jooby.internal.Headers;
import org.jooby.internal.HttpRendererContext;
import org.jooby.internal.InputStreamAsset;
import org.jooby.internal.MutantImpl;
import org.jooby.internal.RequestImpl;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.URLAsset;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.spi.NativeResponse;
import org.slf4j.LoggerFactory;

public class ResponseImpl
implements Response {
    private static final String LOCATION = "Location";
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"%s\"; filename*=%s''%s";
    private final NativeResponse rsp;
    private final Map<String, Object> locals;
    private Route route;
    private Charset charset;
    private final Optional<String> referer;
    private Status status;
    private MediaType type;
    private long len = -1L;
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private List<Renderer> renderers;
    private ParserExecutor parserExecutor;
    private Map<String, Renderer> rendererMap;
    private List<Route.After> after = new ArrayList<Route.After>();
    private List<Route.Complete> complete = new ArrayList<Route.Complete>();
    private RequestImpl req;
    private boolean failure;
    private Optional<String> byteRange;
    private boolean resetHeadersOnError = true;

    public ResponseImpl(RequestImpl req, ParserExecutor parserExecutor, NativeResponse rsp, Route route, List<Renderer> renderers, Map<String, Renderer> rendererMap, Map<String, Object> locals, Charset charset, Optional<String> referer, Optional<String> byteRange) {
        this.req = req;
        this.parserExecutor = parserExecutor;
        this.rsp = rsp;
        this.route = route;
        this.locals = locals;
        this.renderers = renderers;
        this.rendererMap = rendererMap;
        this.charset = charset;
        this.referer = referer;
        this.byteRange = byteRange;
    }

    @Override
    public boolean isResetHeadersOnError() {
        return this.resetHeadersOnError;
    }

    @Override
    public void setResetHeadersOnError(boolean resetHeadersOnError) {
        this.resetHeadersOnError = resetHeadersOnError;
    }

    @Override
    public void download(String filename, InputStream stream) throws Throwable {
        Objects.requireNonNull(filename, "A file's name is required.");
        Objects.requireNonNull(stream, "A stream is required.");
        this.type(this.type().orElseGet(() -> MediaType.byPath(filename).orElse(MediaType.octetstream)));
        InputStreamAsset asset = new InputStreamAsset(stream, filename, this.type);
        this.contentDisposition(filename);
        this.send(Results.with(asset.stream()));
    }

    @Override
    public void download(String filename, String location) throws Throwable {
        URL url = this.getClass().getResource(location.startsWith("/") ? location : "/" + location);
        if (url == null) {
            throw new FileNotFoundException(location);
        }
        this.type(this.type().orElseGet(() -> MediaType.byPath(filename).orElse(MediaType.byPath(location).orElse(MediaType.octetstream))));
        URLAsset asset = new URLAsset(url, location, this.type);
        this.length(asset.length());
        this.contentDisposition(filename);
        this.send(Results.with(asset));
    }

    @Override
    public Response clearCookie(String name) {
        Objects.requireNonNull(name, "Cookie's name required.");
        return this.cookie(new Cookie.Definition(name).maxAge(0));
    }

    @Override
    public Response cookie(Cookie.Definition cookie) {
        Objects.requireNonNull(cookie, "Cookie required.");
        cookie.path(cookie.path().orElse(Route.normalize(this.req.contextPath() + "/")));
        return this.cookie(cookie.toCookie());
    }

    @Override
    public Response cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Cookie required.");
        String name = cookie.name();
        if (cookie.maxAge() == 0) {
            if (this.cookies.remove(name) == null) {
                this.cookies.put(name, cookie);
            }
        } else {
            this.cookies.put(name, cookie);
        }
        return this;
    }

    @Override
    public Mutant header(String name) {
        Objects.requireNonNull(name, "A header's name is required.");
        return new MutantImpl(this.parserExecutor, new StrParamReferenceImpl("header", name, this.rsp.headers(name)));
    }

    @Override
    public Response header(String name, Object value) {
        Objects.requireNonNull(name, "Header's name is required.");
        Objects.requireNonNull(value, "Header's value is required.");
        return this.setHeader(name, value);
    }

    @Override
    public Response header(String name, Iterable<Object> values) {
        Objects.requireNonNull(name, "Header's name is required.");
        Objects.requireNonNull(values, "Header's values are required.");
        return this.setHeader(name, values);
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public Response charset(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "A charset is required.");
        this.type(this.type().orElse(MediaType.html));
        return this;
    }

    @Override
    public Response length(long length) {
        this.len = length;
        this.rsp.header("Content-Length", Long.toString(length));
        return this;
    }

    @Override
    public Optional<MediaType> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public Response type(MediaType type) {
        this.type = type;
        if (type.isText()) {
            this.setHeader("Content-Type", type.name() + ";charset=" + this.charset.name());
        } else {
            this.setHeader("Content-Type", type.name());
        }
        return this;
    }

    @Override
    public void redirect(Status status, String location) throws Throwable {
        Objects.requireNonNull(status, "Status required.");
        Objects.requireNonNull(location, "Location required.");
        this.send(Results.with(status).header(LOCATION, (Object)location));
    }

    @Override
    public Optional<Status> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    public Response status(Status status) {
        this.status = Objects.requireNonNull(status, "Status required.");
        this.rsp.statusCode(status.value());
        this.failure = status.isError();
        return this;
    }

    @Override
    public boolean committed() {
        return this.rsp.committed();
    }

    public void done(Optional<Throwable> cause) {
        if (this.complete.size() > 0) {
            for (Route.Complete h2 : this.complete) {
                Try.run(() -> h2.handle((Request)this.req, (Response)this, cause)).onFailure(x -> LoggerFactory.getLogger(Response.class).error("complete listener resulted in error", x));
            }
            this.complete.clear();
        }
        this.end();
    }

    @Override
    public void end() {
        if (!this.rsp.committed()) {
            boolean lenSet;
            if (this.status == null) {
                this.status(this.rsp.statusCode());
            }
            this.writeCookies();
            boolean bl = lenSet = this.rsp.header("Content-Length").isPresent() || this.rsp.header("Transfer-Encoding").isPresent();
            if (!lenSet) {
                int statusCode = this.status.value();
                boolean hasBody = true;
                if (statusCode >= 100 && statusCode < 200) {
                    hasBody = false;
                } else if (statusCode == 204 || statusCode == 304) {
                    hasBody = false;
                }
                if (hasBody) {
                    this.rsp.header("Content-Length", "0");
                }
            }
        }
        this.rsp.end();
    }

    @Override
    public void send(Result result) throws Throwable {
        Optional<Status> finalStatus;
        Optional<MediaType> rtype;
        if (result instanceof Deferred) {
            throw new DeferredExecution((Deferred)result);
        }
        Result finalResult = result;
        if (!this.failure) {
            for (int i = this.after.size() - 1; i >= 0; --i) {
                finalResult = this.after.get(i).handle((Request)this.req, (Response)this, finalResult);
            }
        }
        if ((rtype = finalResult.type()).isPresent()) {
            this.type(rtype.get());
        }
        if ((finalStatus = finalResult.status()).isPresent()) {
            this.status(finalStatus.get());
        } else if (this.status == null) {
            this.status(Status.OK);
        }
        Map<String, Object> headers = finalResult.headers();
        if (headers.size() > 0) {
            headers.forEach(this::setHeader);
        }
        this.writeCookies();
        if ("HEAD".equals(this.route.method())) {
            this.end();
            return;
        }
        List<MediaType> produces = this.type == null ? this.route.produces() : ImmutableList.of(this.type);
        Object value = finalResult.get(produces);
        if (value != null) {
            Consumer<Long> setLen = len -> {
                if (this.len == -1L && len >= 0L) {
                    this.length((long)len);
                }
            };
            Consumer<MediaType> setType = type -> {
                if (this.type == null) {
                    this.type((MediaType)type);
                }
            };
            HttpRendererContext ctx = new HttpRendererContext(this.renderers, this.rsp, setLen, setType, this.locals, produces, this.charset, this.req.locale(), this.byteRange);
            Renderer renderer = this.rendererMap.get(this.route.renderer());
            if (renderer != null) {
                renderer.render(value, ctx);
            } else {
                ctx.render(value);
            }
        }
        this.end();
    }

    @Override
    public void after(Route.After handler) {
        this.after.add(handler);
    }

    @Override
    public void complete(Route.Complete handler) {
        this.complete.add(handler);
    }

    private void writeCookies() {
        if (this.cookies.size() > 0) {
            List<String> setCookie = this.cookies.values().stream().map(Cookie::encode).collect(Collectors.toList());
            this.rsp.header("Set-Cookie", setCookie);
            this.cookies.clear();
        }
    }

    public void reset() {
        if (this.resetHeadersOnError) {
            this.status = null;
            this.cookies.clear();
            this.rsp.reset();
        }
    }

    void route(Route route) {
        this.route = route;
    }

    private void contentDisposition(String filename) throws IOException {
        List<String> headers = this.rsp.headers("Content-Disposition");
        if (headers.isEmpty()) {
            String basename = filename;
            int last = filename.lastIndexOf(47);
            if (last >= 0) {
                basename = basename.substring(last + 1);
            }
            String cs = this.charset.name();
            String ebasename = URLEncoder.encode(basename, cs).replaceAll("\\+", "%20");
            this.header("Content-Disposition", (Object)String.format(CONTENT_DISPOSITION, basename, cs, ebasename));
        }
    }

    private Response setHeader(String name, Object value) {
        if (!this.committed()) {
            if (value instanceof Iterable) {
                List<String> values = StreamSupport.stream(((Iterable)value).spliterator(), false).map(Headers::encode).collect(Collectors.toList());
                this.rsp.header(name, values);
            } else if (LOCATION.equalsIgnoreCase(name)) {
                String location = value.toString();
                String cpath = this.req.contextPath();
                if ("back".equalsIgnoreCase(location)) {
                    location = this.referer.orElse(cpath + "/");
                } else if (location.startsWith("/") && !location.startsWith(cpath)) {
                    location = cpath + location;
                }
                this.rsp.header(LOCATION, location);
            } else {
                if ("Content-Type".equalsIgnoreCase(name)) {
                    this.type = MediaType.valueOf(value.toString());
                }
                this.rsp.header(name, Headers.encode(value));
            }
        }
        return this;
    }
}

