/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import org.jooby.internal.RouteMatcher;

public class RegexRouteMatcher
implements RouteMatcher {
    private final Matcher matcher;
    private final List<String> varNames;
    private final Map<Object, String> vars = new HashMap<Object, String>();
    private final String path;

    public RegexRouteMatcher(String path, Matcher matcher, List<String> varNames) {
        this.path = Objects.requireNonNull(path, "A path is required.");
        this.matcher = Objects.requireNonNull(matcher, "A matcher is required.");
        this.varNames = Objects.requireNonNull(varNames, "The varNames are required.");
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public boolean matches() {
        boolean matches = this.matcher.matches();
        if (matches) {
            int varCount = this.varNames.size();
            int groupCount = this.matcher.groupCount();
            for (int idx = 0; idx < groupCount; ++idx) {
                String var = this.matcher.group(idx + 1);
                if (var.startsWith("/")) {
                    var = var.substring(1);
                }
                this.vars.put(idx, var);
                if (idx >= varCount) continue;
                this.vars.put(this.varNames.get(idx), this.matcher.group("v" + idx));
            }
        }
        return matches;
    }

    @Override
    public Map<Object, String> vars() {
        return this.vars;
    }
}

