/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.RouteWithFilter;

public class FallbackRoute
implements RouteWithFilter {
    private Route.Filter filter;
    private String path;
    private String method;
    private String name;
    private List<MediaType> produces;

    public FallbackRoute(String name, String method, String path, List<MediaType> produces, Route.Filter filter) {
        this.name = name;
        this.path = path;
        this.method = method;
        this.filter = filter;
        this.produces = produces;
    }

    @Override
    public String renderer() {
        return null;
    }

    @Override
    public String path() {
        return Route.unerrpath(this.path);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String pattern() {
        return Route.unerrpath(this.path);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Map<Object, String> vars() {
        return Collections.emptyMap();
    }

    @Override
    public List<MediaType> consumes() {
        return MediaType.ALL;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    @Override
    public Map<String, Object> attributes() {
        return Collections.emptyMap();
    }

    @Override
    public boolean glob() {
        return false;
    }

    @Override
    public String reverse(Map<String, Object> vars) {
        return Route.unerrpath(this.path);
    }

    @Override
    public String reverse(Object ... values) {
        return Route.unerrpath(this.path);
    }

    @Override
    public Route.Source source() {
        return Route.Source.BUILTIN;
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        this.filter.handle(req, rsp, chain);
    }

    @Override
    public boolean apply(String prefix) {
        return true;
    }
}

